/*
 * Decompiled with CFR 0.152.
 */
package com.mnglpad;

import com.mnglpad.About;
import com.mnglpad.Find;
import com.mnglpad.FontChooser;
import com.mongol.swing.MTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class MongolPad
extends JFrame
implements ActionListener {
    Container container;
    public JScrollPane scrollpane;
    public MTextArea editor;
    public static final String imageSuffix = "Image";
    public static final String actionSuffix = "Action";
    public static final String tipSuffix = "Tooltip";
    private JMenuBar menubar;
    private JToolBar toolbar;
    private JComponent status;
    private JMenu file;
    private JMenuItem file_new;
    private JMenuItem file_open;
    private JSeparator file_sep1;
    private JMenuItem file_save;
    private JMenuItem file_save_as;
    private JSeparator file_sep2;
    private JMenuItem file_print;
    private JSeparator file_sep3;
    private JMenuItem file_close;
    private JMenuItem file_exit;
    private JMenu edit;
    private JMenuItem edit_undo;
    private JMenuItem edit_redo;
    private JSeparator edit_sep1;
    private JMenuItem edit_copy;
    private JMenuItem edit_cut;
    private JMenuItem edit_paste;
    private JMenuItem edit_delete;
    private JSeparator edit_sep2;
    private JMenuItem edit_find;
    private JMenuItem edit_find_next;
    private JMenuItem edit_replace;
    private JSeparator edit_sep3;
    private JMenuItem edit_selectall;
    private JMenuItem edit_timedate;
    private JMenu format;
    private JMenuItem format_font;
    private JMenu convert;
    private JMenuItem str2uppr;
    private JMenuItem str2lwr;
    private JCheckBoxMenuItem format_wordwarp;
    private JMenu help;
    private JMenuItem help_about;
    private JButton button_about;
    private JButton button_new;
    private JButton button_open;
    private JButton button_save;
    private JButton button_save_as;
    private JButton button_copy;
    private JButton button_cut;
    private JButton button_paste;
    private JButton button_delete;
    private JButton button_find;
    private JButton button_find_next;
    private JButton button_replace;
    private JButton button_font;
    private JButton button_print;
    private JButton button_exit;
    Dimension winSize;
    Rectangle editorBounds;
    UndoManager undo = new UndoManager();
    UIManager.LookAndFeelInfo[] lnf;
    Find finder;
    FontChooser fontchooser;
    About about;
    String path;
    String content;
    private static ResourceBundle resources;

    static {
        try {
            resources = ResourceBundle.getBundle("resources.MongolPad", Locale.getDefault());
        }
        catch (MissingResourceException mre) {
            System.err.println("resources/MongolPad.properties not found");
            System.exit(1);
        }
    }

    public MongolPad(String filename) {
        super("Untitled - Mongolpad");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Container c = this.getContentPane();
        this.editor = new MTextArea();
        this.editor.setRotateDirection(1);
        this.editor.setRotateHint(2);
        this.editor.setDragEnabled(true);
        this.editor.setLineWrap(true);
        this.editor.setWrapStyleWord(true);
        Font defaultFont = new Font("Mongolian White", 0, 24);
        this.editor.setFont(defaultFont);
        this.scrollpane = new JScrollPane(this.editor, 20, 30);
        c.add(this.scrollpane);
        this.menubar = this.createMenubar();
        this.setJMenuBar(this.menubar);
        this.toolbar = this.createToolbar();
        c.add((Component)this.toolbar, "North");
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent evt) {
                Component c = (Component)evt.getSource();
                Dimension newSize = c.getSize();
                if (MongolPad.this.winSize != null && newSize.height != MongolPad.this.winSize.height) {
                    int scrollHight = MongolPad.this.editor.getParent().getHeight();
                    if (MongolPad.this.scrollpane.getHorizontalScrollBar().isShowing()) {
                        MongolPad.this.editor.setSize(Integer.MAX_VALUE, scrollHight - 20);
                    } else {
                        MongolPad.this.editor.setSize(Integer.MAX_VALUE, scrollHight - 20);
                    }
                }
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.add(this.createStatusbar(), "South");
        Document doc = this.editor.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent event) {
                MongolPad.this.undo.addEdit(event.getEdit());
            }
        });
        this.finder = new Find(this);
        this.finder.setDefaultCloseOperation(1);
        this.fontchooser = new FontChooser(this);
        this.about = new About(this);
        int w = 800;
        int h = 748;
        this.setSize(w, h);
        Point center = GraphicsEnvironment.getLocalGraphicsEnvironment().getCenterPoint();
        this.setLocation(center.x - w / 2, center.y - h / 2);
        this.setVisible(true);
        this.path = "";
        this.winSize = this.getSize();
        this.editorBounds = this.editor.getBounds();
        this.editor_resize();
        if (filename != null) {
            this.file_load(filename);
        }
    }

    public void editor_resize() {
        Dimension newSize = this.getSize();
        if (this.winSize != null && newSize.height != this.winSize.height) {
            int scrollHight = this.editor.getParent().getHeight();
            if (this.scrollpane.getHorizontalScrollBar().isShowing()) {
                this.editor.setSize(Integer.MAX_VALUE, scrollHight - 20);
            } else {
                this.editor.setSize(Integer.MAX_VALUE, scrollHight - 20);
            }
        }
    }

    protected JMenuBar createMenubar() {
        JMenuBar mb = new JMenuBar();
        this.file = new JMenu(this.getResourceString("FileLabel"));
        this.file_new = new JMenuItem(this.getResourceString("NewLabel"));
        URL url = this.getResource("NewImage");
        if (url != null) {
            this.file_new.setHorizontalTextPosition(4);
            this.file_new.setIcon(new ImageIcon(url));
        }
        this.file_new.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        this.file_new.addActionListener(this);
        this.file.add(this.file_new);
        this.file_open = new JMenuItem(this.getResourceString("OpenLabel"));
        url = this.getResource("OpenImage");
        if (url != null) {
            this.file_open.setHorizontalTextPosition(4);
            this.file_open.setIcon(new ImageIcon(url));
        }
        this.file_open.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        this.file_open.addActionListener(this);
        this.file.add(this.file_open);
        this.file_sep1 = new JSeparator();
        this.file.add(this.file_sep1);
        this.file_save = new JMenuItem(this.getResourceString("SaveLabel"));
        url = this.getResource("SaveImage");
        if (url != null) {
            this.file_save.setHorizontalTextPosition(4);
            this.file_save.setIcon(new ImageIcon(url));
        }
        this.file_save.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        this.file_save.addActionListener(this);
        this.file.add(this.file_save);
        this.file_save_as = new JMenuItem(this.getResourceString("SaveAsLabel"));
        url = this.getResource("SaveAsImage");
        if (url != null) {
            this.file_save_as.setHorizontalTextPosition(4);
            this.file_save_as.setIcon(new ImageIcon(url));
        }
        this.file_save_as.addActionListener(this);
        this.file.add(this.file_save_as);
        this.file_sep2 = new JSeparator();
        this.file.add(this.file_sep2);
        this.file_close = new JMenuItem(this.getResourceString("CloseLabel"));
        url = this.getResource("CloseImage");
        if (url != null) {
            this.file_close.setHorizontalTextPosition(4);
            this.file_close.setIcon(new ImageIcon(url));
        }
        this.file_close.setAccelerator(KeyStroke.getKeyStroke(115, 2));
        this.file_close.addActionListener(this);
        this.file.add(this.file_close);
        this.file_exit = new JMenuItem(this.getResourceString("ExitLabel"));
        url = this.getResource("ExitImage");
        if (url != null) {
            this.file_close.setHorizontalTextPosition(4);
            this.file_close.setIcon(new ImageIcon(url));
        }
        this.file_exit.setAccelerator(KeyStroke.getKeyStroke(115, 8));
        this.file_exit.addActionListener(this);
        this.file.add(this.file_exit);
        mb.add(this.file);
        this.edit = new JMenu(this.getResourceString("EditLabel"));
        this.edit_undo = new JMenuItem(this.getResourceString("UndoLabel"));
        url = this.getResource("UndoImage");
        if (url != null) {
            this.edit_undo.setHorizontalTextPosition(4);
            this.edit_undo.setIcon(new ImageIcon(url));
        }
        this.edit_undo.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        this.edit_undo.addActionListener(this);
        this.edit.add(this.edit_undo);
        this.edit_redo = new JMenuItem(this.getResourceString("RedoLabel"));
        url = this.getResource("RedoImage");
        if (url != null) {
            this.edit_redo.setHorizontalTextPosition(4);
            this.edit_redo.setIcon(new ImageIcon(url));
        }
        this.edit_redo.setAccelerator(KeyStroke.getKeyStroke(89, 2));
        this.edit_redo.addActionListener(this);
        this.edit.add(this.edit_redo);
        this.edit_sep1 = new JSeparator();
        this.edit.add(this.edit_sep1);
        this.edit_copy = new JMenuItem(this.getResourceString("CopyLabel"));
        url = this.getResource("CopyImage");
        if (url != null) {
            this.edit_copy.setHorizontalTextPosition(4);
            this.edit_copy.setIcon(new ImageIcon(url));
        }
        this.edit_copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.edit_copy.addActionListener(this);
        this.edit.add(this.edit_copy);
        this.edit_cut = new JMenuItem(this.getResourceString("CutLabel"));
        url = this.getResource("CutImage");
        if (url != null) {
            this.edit_cut.setHorizontalTextPosition(4);
            this.edit_cut.setIcon(new ImageIcon(url));
        }
        this.edit_cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.edit_cut.addActionListener(this);
        this.edit.add(this.edit_cut);
        this.edit_paste = new JMenuItem(this.getResourceString("PasteLabel"));
        url = this.getResource("PasteImage");
        if (url != null) {
            this.edit_paste.setHorizontalTextPosition(4);
            this.edit_paste.setIcon(new ImageIcon(url));
        }
        this.edit_paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.edit_paste.addActionListener(this);
        this.edit.add(this.edit_paste);
        this.edit_delete = new JMenuItem(this.getResourceString("DeleteLabel"));
        url = this.getResource("DeleteImage");
        if (url != null) {
            this.edit_delete.setHorizontalTextPosition(4);
            this.edit_delete.setIcon(new ImageIcon(url));
        }
        this.edit_delete.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.edit_delete.addActionListener(this);
        this.edit.add(this.edit_delete);
        this.edit_sep2 = new JSeparator();
        this.edit.add(this.edit_sep2);
        this.edit_find = new JMenuItem(this.getResourceString("FindLabel"));
        url = this.getResource("FindImage");
        if (url != null) {
            this.edit_find.setHorizontalTextPosition(4);
            this.edit_find.setIcon(new ImageIcon(url));
        }
        this.edit_find.setAccelerator(KeyStroke.getKeyStroke(70, 2));
        this.edit_find.addActionListener(this);
        this.edit.add(this.edit_find);
        this.edit_find_next = new JMenuItem(this.getResourceString("FindNextLabel"));
        url = this.getResource("FindNextImage");
        if (url != null) {
            this.edit_find_next.setHorizontalTextPosition(4);
            this.edit_find_next.setIcon(new ImageIcon(url));
        }
        this.edit_find_next.setAccelerator(KeyStroke.getKeyStroke(114, 0));
        this.edit_find_next.addActionListener(this);
        this.edit.add(this.edit_find_next);
        this.edit_replace = new JMenuItem(this.getResourceString("ReplaceLabel"));
        url = this.getResource("ReplaceImage");
        if (url != null) {
            this.edit_replace.setHorizontalTextPosition(4);
            this.edit_replace.setIcon(new ImageIcon(url));
        }
        this.edit_replace.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.edit_replace.addActionListener(this);
        this.edit.add(this.edit_replace);
        this.edit_sep3 = new JSeparator();
        this.edit.add(this.edit_sep3);
        this.edit_selectall = new JMenuItem(this.getResourceString("SelectAllLabel"));
        this.edit_selectall.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.edit_selectall.addActionListener(this);
        this.edit.add(this.edit_selectall);
        this.edit_timedate = new JMenuItem(this.getResourceString("DateTimeLabel"));
        url = this.getResource("DateTimeImage");
        if (url != null) {
            this.edit_timedate.setHorizontalTextPosition(4);
            this.edit_timedate.setIcon(new ImageIcon(url));
        }
        this.edit_timedate.setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.edit_timedate.addActionListener(this);
        this.edit.add(this.edit_timedate);
        mb.add(this.edit);
        this.format = new JMenu(this.getResourceString("FormatLabel"));
        this.format_font = new JMenuItem(this.getResourceString("FontLabel"));
        url = this.getResource("FontImage");
        if (url != null) {
            this.format_font.setHorizontalTextPosition(4);
            this.format_font.setIcon(new ImageIcon(url));
        }
        this.format_font.addActionListener(this);
        this.format.add(this.format_font);
        this.convert = new JMenu(this.getResourceString("ConvertLabel"));
        this.str2uppr = new JMenuItem(this.getResourceString("ToUppercaseLabel"));
        this.str2uppr.setAccelerator(KeyStroke.getKeyStroke(38, 2));
        this.str2uppr.addActionListener(this);
        this.convert.add(this.str2uppr);
        this.str2lwr = new JMenuItem(this.getResourceString("ToLowercaseLabel"));
        this.str2lwr.setAccelerator(KeyStroke.getKeyStroke(40, 2));
        this.str2lwr.addActionListener(this);
        this.convert.add(this.str2lwr);
        this.format.add(this.convert);
        this.format_wordwarp = new JCheckBoxMenuItem(this.getResourceString("WordWrapLabel"));
        this.format_wordwarp.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        this.format_wordwarp.addActionListener(this);
        this.format_wordwarp.setState(this.editor.getLineWrap());
        this.format.add(this.format_wordwarp);
        mb.add(this.format);
        this.help = new JMenu(this.getResourceString("HelpLabel"));
        this.help_about = new JMenuItem(this.getResourceString("AboutLabel"));
        url = this.getResource("AboutImage");
        if (url != null) {
            this.help_about.setHorizontalTextPosition(4);
            this.help_about.setIcon(new ImageIcon(url));
        }
        this.help_about.setAccelerator(KeyStroke.getKeyStroke(112, 0));
        this.help_about.addActionListener(this);
        this.help.add(this.help_about);
        mb.add(this.help);
        return mb;
    }

    private JToolBar createToolbar() {
        JToolBar tb = new JToolBar();
        this.button_new = this.createTool("New");
        tb.add(this.button_new);
        this.button_open = this.createTool("Open");
        tb.add(this.button_open);
        this.button_save = this.createTool("Save");
        tb.add(this.button_save);
        this.button_save_as = this.createTool("SaveAs");
        tb.add(this.button_save_as);
        tb.add(Box.createHorizontalStrut(5));
        this.button_copy = this.createTool("Copy");
        tb.add(this.button_copy);
        this.button_cut = this.createTool("Cut");
        tb.add(this.button_cut);
        this.button_paste = this.createTool("Paste");
        tb.add(this.button_paste);
        this.button_delete = this.createTool("Delete");
        tb.add(this.button_delete);
        tb.add(Box.createHorizontalStrut(5));
        this.button_find = this.createTool("Find");
        tb.add(this.button_find);
        this.button_find_next = this.createTool("FindNext");
        tb.add(this.button_find_next);
        this.button_replace = this.createTool("Replace");
        tb.add(this.button_replace);
        tb.add(Box.createHorizontalStrut(5));
        this.button_font = this.createTool("Font");
        tb.add(this.button_font);
        tb.add(Box.createHorizontalStrut(5));
        this.button_exit = this.createTool("Exit");
        tb.add(this.button_exit);
        tb.add(Box.createHorizontalGlue());
        return tb;
    }

    protected JButton createTool(String key) {
        return this.createToolbarButton(key);
    }

    protected JButton createToolbarButton(String key) {
        URL url = this.getResource(String.valueOf(key) + imageSuffix);
        JButton b = new JButton((Icon)new ImageIcon(url)){

            @Override
            public float getAlignmentY() {
                return 0.5f;
            }
        };
        b.setRequestFocusEnabled(false);
        b.setMargin(new Insets(1, 1, 1, 1));
        String astr = this.getResourceString(String.valueOf(key) + actionSuffix);
        if (astr == null) {
            astr = key;
        }
        b.setActionCommand(astr);
        b.addActionListener(this);
        String tip = this.getResourceString(String.valueOf(key) + tipSuffix);
        if (tip != null) {
            b.setToolTipText(tip);
        }
        return b;
    }

    protected Component createStatusbar() {
        this.status = new StatusBar();
        return this.status;
    }

    public String getResourceString(String nm) {
        String str;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {
            str = null;
        }
        return str;
    }

    protected URL getResource(String key) {
        String name = this.getResourceString(key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.file_new || e.getSource() == this.button_new) {
            this.file_new();
        } else if (e.getSource() == this.file_open || e.getSource() == this.button_open) {
            this.file_open();
        } else if (e.getSource() == this.file_save || e.getSource() == this.button_save) {
            this.file_save();
        } else if (e.getSource() == this.file_save_as || e.getSource() == this.button_save_as) {
            this.file_save_as();
        } else if (e.getSource() == this.file_print || e.getSource() == this.button_print) {
            this.file_print();
        } else if (e.getSource() == this.file_close) {
            this.file_close();
        } else if (e.getSource() == this.file_exit || e.getSource() == this.button_exit) {
            this.file_exit();
        } else if (e.getSource() == this.edit_undo) {
            this.edit_undo();
        } else if (e.getSource() == this.edit_redo) {
            this.edit_redo();
        } else if (e.getSource() == this.edit_cut || e.getSource() == this.button_cut) {
            this.edit_cut();
        } else if (e.getSource() == this.edit_copy || e.getSource() == this.button_copy) {
            this.edit_copy();
        } else if (e.getSource() == this.edit_paste || e.getSource() == this.button_paste) {
            this.edit_paste();
        } else if (e.getSource() == this.edit_delete || e.getSource() == this.button_delete) {
            this.edit_delete();
        } else if (e.getSource() == this.edit_find || e.getSource() == this.button_find) {
            this.edit_find();
        } else if (e.getSource() == this.edit_find_next || e.getSource() == this.button_find_next) {
            this.edit_find_next();
        } else if (e.getSource() == this.edit_replace || e.getSource() == this.button_replace) {
            this.edit_replace();
        } else if (e.getSource() == this.edit_selectall) {
            this.edit_selectall();
        } else if (e.getSource() == this.edit_timedate) {
            this.edit_timedate();
        } else if (e.getSource() == this.format_font || e.getSource() == this.button_font) {
            this.format_font();
        } else if (e.getSource() == this.str2uppr) {
            this.str2uppr();
        } else if (e.getSource() == this.str2lwr) {
            this.str2lwr();
        } else if (e.getSource() == this.format_wordwarp) {
            this.format_wordwarp();
        } else if (e.getSource() == this.help_about || e.getSource() == this.button_about) {
            this.help_about();
        }
    }

    public void file_new() {
        if (this.editor.getText().equals("") || this.editor.getText().equals(this.content)) {
            this.editor.setText("");
            this.content = "";
            this.path = "";
            this.setTitle("untitled - MongolPad");
        } else {
            int a = JOptionPane.showConfirmDialog(null, "The text has been changed\nDo you want to save the changes?");
            if (a == 0) {
                this.file_save();
            } else if (a == 1) {
                this.editor.setText("");
                this.path = "";
                this.setTitle("untitled - MongolPad");
            } else if (a == 2) {
                return;
            }
        }
    }

    public void file_load(String filename) {
        File myfile = new File(filename);
        if (myfile == null || myfile.getName().equals("")) {
            this.path = filename;
            this.setTitle(String.valueOf(filename) + " - MongolPad");
            return;
        }
        try {
            String line;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(myfile), "UTF-8");
            BufferedReader input = new BufferedReader(isr);
            StringBuffer str = new StringBuffer();
            while ((line = input.readLine()) != null) {
                str.append(String.valueOf(line) + "\n");
            }
            this.editor.setText(str.toString());
            this.content = this.editor.getText();
            this.path = myfile.toString();
            this.setTitle(String.valueOf(myfile.getName()) + " - MongolPad");
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "File not found: " + e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "IO ERROR: " + e);
        }
    }

    public void file_open() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        int r = fc.showOpenDialog(this);
        if (r == 1) {
            return;
        }
        File myfile = fc.getSelectedFile();
        if (myfile == null || myfile.getName().equals("")) {
            JOptionPane.showMessageDialog(this, "Select a file!", "Error", 0);
            return;
        }
        try {
            String line;
            InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(myfile), "UTF-8");
            BufferedReader input = new BufferedReader(isr);
            StringBuffer str = new StringBuffer();
            while ((line = input.readLine()) != null) {
                str.append(String.valueOf(line) + "\n");
            }
            this.editor.setText(str.toString());
            this.content = this.editor.getText();
            this.editor.setCaretPosition(0);
            this.path = myfile.toString();
            this.setTitle(String.valueOf(myfile.getName()) + " - MongolPad");
            Dimension newSize = this.getSize();
            ++newSize.height;
            this.setSize(newSize);
            this.editor_resize();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "File not found: " + e);
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "IO ERROR: " + e);
        }
    }

    public void file_save() {
        if (this.path.equals("")) {
            this.file_save_as();
            return;
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(this.path), "UTF-8");
            BufferedWriter output = new BufferedWriter(osw);
            StringBuffer str = new StringBuffer(this.editor.getText());
            int i = 0;
            while (i < str.length()) {
                char c;
                char ic = c = str.charAt(i);
                if (c != '\n') {
                    output.append(c);
                } else {
                    output.append("\r\n");
                }
                ++i;
            }
            output.flush();
            this.content = this.editor.getText();
            osw.close();
        }
        catch (IOException i) {
            JOptionPane.showMessageDialog(this, "Failed to save the file", "Error", 0);
        }
    }

    public void file_save_as() {
        JFileChooser fc = new JFileChooser();
        fc.setFileSelectionMode(0);
        int r = fc.showSaveDialog(this);
        if (r == 1) {
            return;
        }
        File myfile = fc.getSelectedFile();
        if (myfile == null || myfile.getName().equals("")) {
            JOptionPane.showMessageDialog(this, "Please enter a file name!", "Error", 0);
            return;
        }
        if (myfile.exists() && (r = JOptionPane.showConfirmDialog(this, "A file with same name already exists!\nAre you sure want to overwrite?")) != 0) {
            return;
        }
        try {
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)new FileOutputStream(myfile), "UTF-8");
            BufferedWriter output = new BufferedWriter(osw);
            StringBuffer str = new StringBuffer(this.editor.getText());
            int i = 0;
            while (i < str.length()) {
                char c;
                char ic = c = str.charAt(i);
                if (c != '\n') {
                    output.append(c);
                } else {
                    output.append("\r\n");
                }
                ++i;
            }
            output.flush();
            this.content = this.editor.getText();
            this.setTitle(String.valueOf(myfile.getName()) + " - MongolPad");
            this.path = myfile.toString();
            osw.close();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, "Failed to save the file", "Error", 0);
        }
    }

    public void file_print() {
        HashPrintRequestAttributeSet printAttr;
        PrinterJob printer = PrinterJob.getPrinterJob();
        if (printer.printDialog(printAttr = new HashPrintRequestAttributeSet())) {
            try {
                printer.print(printAttr);
            }
            catch (PrinterException e) {
                JOptionPane.showMessageDialog(this, "Failed to print the file: " + e, "Error", 0);
            }
        }
    }

    public void file_close() {
        if (this.editor.getText().equals("") || this.editor.getText().equals(this.content)) {
            this.editor.setText("");
            this.path = "";
            this.setTitle("untitled - MongolPad");
        } else {
            int a = JOptionPane.showConfirmDialog(null, "The text has been changed\nDo you want to save the changes?");
            if (a == 0) {
                this.file_save();
            } else if (a == 1) {
                this.editor.setText("");
                this.path = "";
                this.setTitle("untitled - MongolPad");
            } else if (a == 2) {
                return;
            }
        }
    }

    public void file_exit() {
        if (this.editor.getText().equals("") || this.editor.getText().equals(this.content)) {
            System.exit(0);
        } else {
            int b = JOptionPane.showConfirmDialog(null, "The text has been changed.\nDo you want to save the changes?");
            if (b == 0) {
                this.file_save();
            } else if (b == 1) {
                System.exit(0);
            } else if (b == 2) {
                return;
            }
        }
    }

    public void edit_undo() {
        if (this.undo.canUndo()) {
            try {
                this.undo.undo();
            }
            catch (CannotUndoException cannotUndoException) {
                // empty catch block
            }
        }
    }

    public void edit_redo() {
        if (this.undo.canRedo()) {
            try {
                this.undo.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                // empty catch block
            }
        }
    }

    public void edit_cut() {
        this.editor.cut();
    }

    public void edit_copy() {
        this.editor.copy();
    }

    public void edit_paste() {
        this.editor.paste();
    }

    public void edit_delete() {
        String temp = this.editor.getText();
        this.editor.setText(String.valueOf(temp.substring(0, this.editor.getSelectionStart())) + temp.substring(this.editor.getSelectionEnd()));
    }

    public void edit_find() {
        this.finder.setVisible(true);
    }

    public void edit_find_next() {
        this.finder.find_next();
    }

    public void edit_replace() {
        this.finder.setVisible(true);
    }

    public void edit_selectall() {
        this.editor.selectAll();
    }

    public void edit_timedate() {
        try {
            int start = this.editor.getSelectionStart();
            int end = this.editor.getSelectionEnd();
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm");
            String now = sdf.format(cal.getTime());
            String temp1 = this.editor.getText().substring(0, start);
            String temp2 = this.editor.getText().substring(end);
            this.editor.setText(String.valueOf(temp1) + " " + now + " " + temp2);
            this.editor.select(start + 1, start + 1 + now.length());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void format_font() {
        FontChooser.window.show();
        FontChooser.window.setVisible(true);
    }

    public void str2uppr() {
        try {
            int start = this.editor.getSelectionStart();
            int end = this.editor.getSelectionEnd();
            String temp1 = this.editor.getText().substring(0, start);
            String temp2 = this.editor.getText().substring(end);
            String conv = this.editor.getSelectedText().toUpperCase();
            this.editor.setText(String.valueOf(temp1) + conv + temp2);
            this.editor.select(start, end);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void str2lwr() {
        try {
            int start = this.editor.getSelectionStart();
            int end = this.editor.getSelectionEnd();
            String temp1 = this.editor.getText().substring(0, start);
            String temp2 = this.editor.getText().substring(end);
            String conv = this.editor.getSelectedText().toLowerCase();
            this.editor.setText(String.valueOf(temp1) + conv + temp2);
            this.editor.select(start, end);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void format_wordwarp() {
        if (!this.editor.getLineWrap()) {
            this.editor.setLineWrap(true);
        } else {
            this.editor.setLineWrap(false);
        }
        this.editor_resize();
    }

    public void help_about() {
        About.window.setVisible(true);
    }

    protected Frame getFrame() {
        Container p = this.getParent();
        while (p != null) {
            if (p instanceof Frame) {
                return (Frame)p;
            }
            p = p.getParent();
        }
        return null;
    }

    protected JTextComponent getEditor() {
        return this.editor;
    }

    class StatusBar
    extends JComponent {
        public StatusBar() {
            this.setLayout(new BoxLayout(this, 0));
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
        }
    }
}

