/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.encode;

import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.GraphicsEnvironment;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public class MongolianFontUtil {
    private static final Map<String, Font> logicalFont = new HashMap<String, Font>();
    private static boolean initialized = false;

    public static Font getAltFont(Font font, String uiname) {
        Font alt_font = null;
        if (font != null) {
            if (font instanceof FontUIResource) {
                if (MongolianFontUtil.isMongolianFont(font)) {
                    alt_font = UIManager.getFont("TextField.font");
                    int size = font.getSize();
                    if (size > 14) {
                        size -= 6;
                    }
                    alt_font = alt_font.deriveFont(font.getStyle(), size);
                } else {
                    FontUIResource resourcefont = (FontUIResource)font;
                    String family = resourcefont.getFamily();
                    alt_font = MongolianFontUtil.getFont(family);
                    if (alt_font == null) {
                        alt_font = MongolianFontUtil.getFont("Dialog");
                    }
                    int size = font.getSize() + 6;
                    alt_font = alt_font.deriveFont(font.getStyle(), size);
                }
            } else if (MongolianFontUtil.isMongolianFont(font)) {
                alt_font = UIManager.getFont("TextField.font");
                int size = font.getSize();
                if (size > 14) {
                    size -= 6;
                }
                alt_font = alt_font.deriveFont(font.getStyle(), size);
            } else {
                alt_font = MongolianFontUtil.getFont("Dialog");
                int size = font.getSize() + 6;
                alt_font = alt_font.deriveFont(font.getStyle(), size);
            }
        } else {
            alt_font = MongolianFontUtil.getFont("Dialog");
            int size = font.getSize() + 6;
            alt_font = alt_font.deriveFont(font.getStyle(), size);
        }
        return alt_font;
    }

    public static boolean isMongolianFont(Font font) {
        if (!(font == null || "Dialog".equalsIgnoreCase(font.getName()) || "DialogInput".equalsIgnoreCase(font.getName()) || "Serif".equalsIgnoreCase(font.getName()) || "SansSerif".equalsIgnoreCase(font.getName()) || "Monospaced".equalsIgnoreCase(font.getName()))) {
            char c = '\u1820';
            while (c <= '\u1842') {
                if (!font.canDisplay(c)) {
                    return false;
                }
                c = (char)(c + '\u0001');
            }
            c = '\ue820';
            while (c <= '\ue85f') {
                if (!font.canDisplay(c)) {
                    return false;
                }
                c = (char)(c + '\u0001');
            }
            return true;
        }
        return false;
    }

    public static void init() {
        if (!initialized) {
            MongolianFontUtil util = new MongolianFontUtil();
            ClassLoader loader = MongolianFontUtil.class.getClassLoader();
            String mnglWhite = "com/mongol/encode/font/mnglwhiteotf.ttf";
            URL url = loader.getResource(mnglWhite);
            Font font = MongolianFontUtil.makeFont(url);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            String mnglWriting = "com/mongol/encode/font/mnglwritingotf.ttf";
            url = loader.getResource(mnglWriting);
            font = MongolianFontUtil.makeFont(url);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            String mnglArt = "com/mongol/encode/font/mnglartotf.ttf";
            url = loader.getResource(mnglArt);
            font = MongolianFontUtil.makeFont(url);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            String mnglTitle = "com/mongol/encode/font/mngltitleotf.ttf";
            url = loader.getResource(mnglTitle);
            font = MongolianFontUtil.makeFont(url);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            String mnglTester = "com/mongol/encode/font/MongolianWhiteTester.ttf";
            url = loader.getResource(mnglTester);
            font = MongolianFontUtil.makeFont(url);
            GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
            String resource = "com.mongol.encode.Font";
            MongolianFontUtil.registerFont(resource);
            initialized = true;
        }
    }

    public static Font getFont(String family) {
        if (!initialized) {
            MongolianFontUtil.init();
        }
        Font font = logicalFont.get(family.toUpperCase());
        return font;
    }

    public static void registerFont(String resource) {
        if (resource != null) {
            ResourceBundle rb = ResourceBundle.getBundle(resource);
            Enumeration<String> e = rb.getKeys();
            while (e.hasMoreElements()) {
                String family = e.nextElement();
                String fontname = rb.getString(family);
                Font font = new Font(fontname, 0, 16);
                if (family == null || font == null) continue;
                logicalFont.put(family.toUpperCase(), font);
            }
        }
    }

    public static void registerFont(String family, Font font) {
        if (family != null) {
            logicalFont.put(family.toUpperCase(), font);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Font makeFont(URL url) {
        Font font = null;
        InputStream is = null;
        try {
            try {
                is = url.openStream();
                font = Font.createFont(0, is).deriveFont(16.0f);
                is.close();
                return font;
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                if (is == null) return font;
                try {
                    is.close();
                    return font;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return font;
            }
            catch (FontFormatException ffe) {
                ffe.printStackTrace();
                if (is == null) return font;
                try {
                    is.close();
                    return font;
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                return font;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }
}

