/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing;

import com.mongol.swing.plaf.MRotation;
import com.mongol.swing.plaf.MTextAreaUI;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.plaf.TextUI;
import javax.swing.text.Document;

public class MTextArea
extends JTextArea
implements MRotation {
    public MTextArea() {
        MTextAreaUI areaUI = new MTextAreaUI();
        super.setUI(areaUI);
    }

    public MTextArea(String text) {
        super(text);
        MTextAreaUI areaUI = new MTextAreaUI();
        super.setUI(areaUI);
    }

    public MTextArea(Document doc) {
        super(doc);
        MTextAreaUI areaUI = new MTextAreaUI();
        super.setUI(areaUI);
    }

    public MTextArea(int rows, int columns) {
        super(rows, columns);
        MTextAreaUI areaUI = new MTextAreaUI();
        super.setUI(areaUI);
    }

    public MTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        MTextAreaUI areaUI = new MTextAreaUI();
        super.setUI(areaUI);
    }

    public MTextArea(Document doc, String text, int rows, int columns) {
        super(doc, text, rows, columns);
        MTextAreaUI areaUI = new MTextAreaUI();
        super.setUI(areaUI);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.getRotateDirection() != 0) {
            int tmp = size.width;
            size.width = size.height;
            size.height = this.getLineWrap() ? tmp - 15 : tmp;
        }
        return size;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            if (this.getRotateDirection() == 0) {
                return parent.getWidth() > this.getPreferredSize().width;
            }
            if (this.getRotateHint() != 4) {
                if (this.getLineWrap()) {
                    return parent.getWidth() > this.getPreferredSize().width;
                }
                return parent.getWidth() > this.getPreferredSize().width;
            }
            return parent.getWidth() > this.getPreferredSize().width;
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container parent = this.getParent();
        if (parent instanceof JViewport) {
            if (this.getRotateDirection() == 0) {
                return parent.getHeight() > this.getPreferredSize().height;
            }
            if (this.getRotateHint() != 4) {
                if (this.getLineWrap()) {
                    return parent.getHeight() > this.getPreferredSize().height;
                }
                return parent.getHeight() > this.getPreferredSize().height;
            }
            return parent.getHeight() > this.getPreferredSize().height;
        }
        return false;
    }

    @Override
    public void setRotateHint(int hint) {
        TextUI textUI = this.getUI();
        if (textUI instanceof MTextAreaUI) {
            ((MTextAreaUI)textUI).setRotateHint(hint);
        }
    }

    @Override
    public int getRotateHint() {
        TextUI textUI = this.getUI();
        if (textUI instanceof MTextAreaUI) {
            return ((MTextAreaUI)textUI).getRotateHint();
        }
        return 0;
    }

    @Override
    public void setRotateDirection(int direction) {
        TextUI textUI = this.getUI();
        if (textUI instanceof MTextAreaUI) {
            ((MTextAreaUI)textUI).setRotateDirection(direction);
        }
    }

    @Override
    public int getRotateDirection() {
        TextUI textUI = this.getUI();
        if (textUI instanceof MTextAreaUI) {
            return ((MTextAreaUI)textUI).getRotateDirection();
        }
        return 0;
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (this.getRotateDirection() == 0) {
            switch (orientation) {
                case 1: {
                    return this.getRowHeight();
                }
                case 0: {
                    return this.getColumnWidth();
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }
        if (this.getRotateHint() != 4) {
            switch (orientation) {
                case 1: {
                    return this.getColumnWidth();
                }
                case 0: {
                    return this.getRowHeight();
                }
            }
            throw new IllegalArgumentException("Invalid orientation: " + orientation);
        }
        switch (orientation) {
            case 1: {
                return this.getColumnWidth();
            }
            case 0: {
                return this.getRowHeight();
            }
        }
        throw new IllegalArgumentException("Invalid orientation: " + orientation);
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension size = super.getPreferredScrollableViewportSize();
        size = size == null ? new Dimension(400, 400) : size;
        Insets insets = this.getInsets();
        int columns = super.getColumns();
        int rows = super.getRows();
        if (this.getRotateDirection() == 0) {
            size.width = columns == 0 ? size.width : columns * this.getColumnWidth() + insets.left + insets.right;
            size.height = rows == 0 ? size.height : rows * this.getRowHeight() + insets.top + insets.bottom;
        } else if (this.getRotateHint() != 4) {
            size.width = rows == 0 ? size.width : rows * this.getRowHeight() + insets.left + insets.right;
            size.height = columns == 0 ? size.height : columns * this.getColumnWidth() + insets.top + insets.bottom;
        } else {
            size.width = rows == 0 ? size.width : rows * this.getRowHeight() + insets.left + insets.right;
            size.height = columns == 0 ? size.height : columns * this.getColumnWidth() + insets.top + insets.bottom;
        }
        return size;
    }

    @Override
    public void scrollRectToVisible(Rectangle aRect) {
        int dx = this.getX();
        int dy = this.getY();
        Container parent = this.getParent();
        while (parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane)) {
            Rectangle bounds = parent.getBounds();
            dx += bounds.x;
            dy += bounds.y;
            parent = parent.getParent();
        }
        if (parent != null && !(parent instanceof CellRendererPane)) {
            FontMetrics fm;
            if (this.getRotateDirection() == 0) {
                aRect.x += dx;
                aRect.y += dy;
                ((JComponent)parent).scrollRectToVisible(aRect);
                aRect.x -= dx;
                aRect.y -= dy;
            } else if (this.getRotateHint() != 4) {
                fm = this.getFontMetrics(this.getFont());
                int fontHeight = fm.getHeight();
                aRect.x += dx - fontHeight / 2;
                aRect.y += dy;
                ((JComponent)parent).scrollRectToVisible(aRect);
                aRect.x -= dx - fontHeight / 2;
                aRect.y -= dy;
            } else {
                fm = this.getFontMetrics(this.getFont());
                int fontHeight = fm.getHeight();
                aRect.x += dx - fontHeight / 2;
                aRect.y += dy;
                ((JComponent)parent).scrollRectToVisible(aRect);
                aRect.x -= dx - fontHeight / 2;
                aRect.y -= dy;
            }
        }
    }
}

