/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.plaf;

import com.mongol.encode.MongolianConverter;
import com.mongol.swing.MSwingUtilities;
import com.mongol.swing.plaf.MRotation;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicButtonListener;
import javax.swing.plaf.metal.MetalButtonUI;
import sun.awt.AppContext;

public class MButtonUI
extends MetalButtonUI
implements MRotation {
    private int rotate_direction = 0;
    private int rotate_hint = 0;
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();
    protected Color focusColor;
    protected Color selectColor;
    protected Color disabledTextColor;
    private static final Object METAL_BUTTON_UI_KEY = new Object();

    public static ComponentUI createUI(JComponent c) {
        AppContext appContext = AppContext.getAppContext();
        MButtonUI mButtonUI = (MButtonUI)appContext.get(METAL_BUTTON_UI_KEY);
        if (mButtonUI == null) {
            mButtonUI = new MButtonUI();
            appContext.put(METAL_BUTTON_UI_KEY, mButtonUI);
        }
        return mButtonUI;
    }

    @Override
    public void installDefaults(AbstractButton b) {
        super.installDefaults(b);
    }

    @Override
    public void uninstallDefaults(AbstractButton b) {
        super.uninstallDefaults(b);
    }

    @Override
    protected BasicButtonListener createButtonListener(AbstractButton b) {
        return super.createButtonListener(b);
    }

    @Override
    protected Color getSelectColor() {
        this.selectColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "select");
        return this.selectColor;
    }

    @Override
    protected Color getDisabledTextColor() {
        this.disabledTextColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "disabledText");
        return this.disabledTextColor;
    }

    @Override
    protected Color getFocusColor() {
        this.focusColor = UIManager.getColor(String.valueOf(this.getPropertyPrefix()) + "focus");
        return this.focusColor;
    }

    @Override
    protected void paintButtonPressed(Graphics g, AbstractButton b) {
        if (b.isContentAreaFilled()) {
            Dimension size = b.getSize();
            g.setColor(this.getSelectColor());
            g.fillRect(0, 0, size.width, size.height);
        }
    }

    @Override
    protected void paintFocus(Graphics g, AbstractButton b, Rectangle viewRect, Rectangle textRect, Rectangle iconRect) {
        boolean isIcon;
        Rectangle focusRect = new Rectangle();
        String text = b.getText();
        boolean bl = isIcon = b.getIcon() != null;
        if (text != null && !text.equals("")) {
            if (!isIcon) {
                focusRect.setBounds(textRect);
            } else {
                focusRect.setBounds(iconRect.union(textRect));
            }
        } else if (isIcon) {
            focusRect.setBounds(iconRect);
        }
        g.setColor(this.getFocusColor());
        g.drawRect(focusRect.x - 1, focusRect.y - 1, focusRect.width + 1, focusRect.height + 1);
    }

    @Override
    protected void paintText(Graphics g, JComponent c, Rectangle textRect, String text) {
        AbstractButton b = (AbstractButton)c;
        ButtonModel model = b.getModel();
        FontMetrics fm = MSwingUtilities.getFontMetrics(c, g);
        int mnemIndex = b.getDisplayedMnemonicIndex();
        if (model.isEnabled()) {
            g.setColor(b.getForeground());
        } else {
            g.setColor(this.getDisabledTextColor());
        }
        MongolianConverter converter = new MongolianConverter();
        String target = converter.convert(text);
        MSwingUtilities.drawStringUnderlineCharAt(c, g, target, mnemIndex, textRect.x, textRect.y + fm.getAscent(), this.rotate_direction, this.rotate_hint);
    }

    @Override
    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
    }

    @Override
    public int getRotateHint() {
        return this.rotate_hint;
    }

    @Override
    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
    }

    @Override
    public int getRotateDirection() {
        return this.rotate_direction;
    }
}

