/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text;

import com.mongol.encode.MongolianFontUtil;
import com.mongol.swing.text.MGlyphView;
import com.mongol.swing.text.MSegmentCache;
import com.mongol.swing.text.MUtilities;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;

class MGlyphPainter1
extends MGlyphView.GlyphPainter {
    protected FontMetrics metrics;
    protected FontMetrics defaultmetrics;
    protected int width;

    MGlyphPainter1() {
    }

    @Override
    public float getSpan(MGlyphView v, int p0, int p1, TabExpander e, float x) {
        this.sync(v);
        Segment text = v.getText(p0, p1);
        int[] justificationData = this.getJustificationData(v);
        int width = MUtilities.getTabbedTextWidth(v, text, this.metrics, this.defaultmetrics, (int)x, e, p0, justificationData);
        MSegmentCache.releaseSharedSegment(text);
        return width;
    }

    @Override
    public float getHeight(MGlyphView v) {
        this.sync(v);
        return this.metrics.getHeight();
    }

    @Override
    public float getAscent(MGlyphView v) {
        this.sync(v);
        return this.metrics.getAscent();
    }

    @Override
    public float getDescent(MGlyphView v) {
        this.sync(v);
        return this.metrics.getDescent();
    }

    @Override
    public void paint(MGlyphView v, Graphics g, Shape a, int p0, int p1) {
        if (v.getRotateDirection() == 0) {
            this.paintHorizantal(v, g, a, p0, p1);
        } else if (v.getRotateHint() != 4) {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform transform = g2d.getTransform();
            ((Graphics2D)g).rotate(1.5707963267948966);
            this.paintVerticalL2R(v, g, a, p0, p1);
            g2d.setTransform(transform);
        } else {
            Graphics2D g2d = (Graphics2D)g;
            AffineTransform transform = g2d.getTransform();
            Rectangle clip = g.getClipBounds();
            this.width = clip.width;
            ((Graphics2D)g).rotate(1.5707963267948966);
            g2d.translate(0, -this.width);
            this.paintVerticalR2L(v, g, a, p0, p1);
            g2d.setTransform(transform);
        }
    }

    private void paintHorizantal(MGlyphView v, Graphics g, Shape a, int p0, int p1) {
        Segment text;
        this.sync(v);
        TabExpander expander = v.getTabExpander();
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int x = alloc.x;
        int p = v.getStartOffset();
        int[] justificationData = this.getJustificationData(v);
        if (p != p0) {
            text = v.getText(p, p0);
            int width = MUtilities.getTabbedTextWidth(v, text, this.metrics, this.defaultmetrics, x, expander, p, justificationData);
            x += width;
            MSegmentCache.releaseSharedSegment(text);
        }
        int y = alloc.y + this.metrics.getHeight() - this.metrics.getDescent();
        text = v.getText(p0, p1);
        g.setFont(this.metrics.getFont());
        MUtilities.drawTabbedText(v, text, x, y, g, expander, p0, justificationData);
        MSegmentCache.releaseSharedSegment(text);
    }

    private void paintVerticalL2R(MGlyphView v, Graphics g, Shape a, int p0, int p1) {
        Segment text;
        this.sync(v);
        TabExpander expander = v.getTabExpander();
        Rectangle alloc = a instanceof Rectangle ? new Rectangle((Rectangle)a) : a.getBounds();
        int tmp = alloc.x;
        alloc.x = alloc.y;
        alloc.y = tmp;
        int x = alloc.x;
        int p = v.getStartOffset();
        int[] justificationData = this.getJustificationData(v);
        if (p != p0) {
            text = v.getText(p, p0);
            int width = MUtilities.getTabbedTextWidth(v, text, this.metrics, this.defaultmetrics, x, expander, p, justificationData);
            x += width;
            MSegmentCache.releaseSharedSegment(text);
        }
        int y = -alloc.y - this.metrics.getDescent();
        text = v.getText(p0, p1);
        g.setFont(this.metrics.getFont());
        MUtilities.drawTabbedText(v, text, x, y, g, expander, p0, justificationData);
        MSegmentCache.releaseSharedSegment(text);
    }

    private void paintVerticalR2L(MGlyphView v, Graphics g, Shape a, int p0, int p1) {
        Segment text;
        this.sync(v);
        TabExpander expander = v.getTabExpander();
        Rectangle alloc = a instanceof Rectangle ? new Rectangle((Rectangle)a) : a.getBounds();
        int tmp = alloc.x;
        alloc.x = alloc.y;
        alloc.y = tmp;
        int x = alloc.x;
        int p = v.getStartOffset();
        int[] justificationData = this.getJustificationData(v);
        if (p != p0) {
            text = v.getText(p, p0);
            int width = MUtilities.getTabbedTextWidth(v, text, this.metrics, this.defaultmetrics, x, expander, p, justificationData);
            x += width;
            MSegmentCache.releaseSharedSegment(text);
        }
        int y = alloc.y + this.metrics.getHeight() - this.metrics.getDescent();
        text = v.getText(p0, p1);
        g.setFont(this.metrics.getFont());
        MUtilities.drawTabbedText(v, text, x, y, g, expander, p0, justificationData);
        MSegmentCache.releaseSharedSegment(text);
    }

    @Override
    public Shape modelToView(MGlyphView v, int pos, Position.Bias bias, Shape a) throws BadLocationException {
        if (v.getRotateDirection() == 0) {
            return this.modelToViewHorizantal(v, pos, bias, a);
        }
        if (v.getRotateHint() != 4) {
            return this.modelToViewVerticalL2R(v, pos, bias, a);
        }
        Rectangle retAlloc = this.modelToViewVerticalR2L(v, pos, bias, a).getBounds();
        retAlloc.x = this.width - retAlloc.x;
        return retAlloc;
    }

    private Shape modelToViewHorizantal(MGlyphView v, int pos, Position.Bias bias, Shape a) throws BadLocationException {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        if (pos == p1) {
            return new Rectangle(alloc.x + alloc.width, alloc.y, 0, this.metrics.getHeight());
        }
        if (pos >= p0 && pos <= p1) {
            Segment text = v.getText(p0, pos);
            int[] justificationData = this.getJustificationData(v);
            int width = MUtilities.getTabbedTextWidth(v, text, this.metrics, this.defaultmetrics, alloc.x, expander, p0, justificationData);
            MSegmentCache.releaseSharedSegment(text);
            return new Rectangle(alloc.x + width, alloc.y, 0, this.metrics.getHeight());
        }
        throw new BadLocationException("modelToView - can't convert", p1);
    }

    private Shape modelToViewVerticalL2R(MGlyphView v, int pos, Position.Bias bias, Shape a) throws BadLocationException {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? new Rectangle((Rectangle)a) : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        if (pos == p1) {
            return new Rectangle(alloc.x, alloc.y + alloc.height, this.metrics.getHeight(), 0);
        }
        if (pos >= p0 && pos <= p1) {
            Segment text = v.getText(p0, pos);
            int[] justificationData = this.getJustificationData(v);
            int width = MUtilities.getTabbedTextWidth(v, text, this.metrics, this.defaultmetrics, alloc.y, expander, p0, justificationData);
            MSegmentCache.releaseSharedSegment(text);
            return new Rectangle(alloc.x, alloc.y + width, this.metrics.getHeight(), 0);
        }
        throw new BadLocationException("modelToView - can't convert", p1);
    }

    private Shape modelToViewVerticalR2L(MGlyphView v, int pos, Position.Bias bias, Shape a) throws BadLocationException {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? new Rectangle((Rectangle)a) : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        if (pos == p1) {
            return new Rectangle(alloc.x, alloc.y + alloc.height, this.metrics.getHeight(), 0);
        }
        if (pos >= p0 && pos <= p1) {
            Segment text = v.getText(p0, pos);
            int[] justificationData = this.getJustificationData(v);
            int width = MUtilities.getTabbedTextWidth(v, text, this.metrics, this.defaultmetrics, alloc.y, expander, p0, justificationData);
            MSegmentCache.releaseSharedSegment(text);
            return new Rectangle(alloc.x, alloc.y + width, this.metrics.getHeight(), 0);
        }
        throw new BadLocationException("modelToView - can't convert", p1);
    }

    @Override
    public int viewToModel(MGlyphView v, float x, float y, Shape a, Position.Bias[] biasReturn) {
        if (v.getRotateDirection() == 0) {
            return this.viewToModelHorizantal(v, x, y, a, biasReturn);
        }
        if (v.getRotateHint() != 4) {
            return this.viewToModelVerticalL2R(v, x, y, a, biasReturn);
        }
        return this.viewToModelVerticalR2L(v, x, y, a, biasReturn);
    }

    public int viewToModelHorizantal(MGlyphView v, float x, float y, Shape a, Position.Bias[] biasReturn) {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        Segment text = v.getText(p0, p1);
        int[] justificationData = this.getJustificationData(v);
        int offs = MUtilities.getTabbedTextOffset(v, text, this.metrics, this.defaultmetrics, alloc.x, (int)x, expander, p0, justificationData);
        MSegmentCache.releaseSharedSegment(text);
        int retValue = p0 + offs;
        if (retValue == p1) {
            --retValue;
        }
        biasReturn[0] = Position.Bias.Forward;
        return retValue;
    }

    public int viewToModelVerticalL2R(MGlyphView v, float x, float y, Shape a, Position.Bias[] biasReturn) {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        Segment text = v.getText(p0, p1);
        int[] justificationData = this.getJustificationData(v);
        int offs = MUtilities.getTabbedTextOffset(v, text, this.metrics, this.defaultmetrics, alloc.y, (int)y, expander, p0, justificationData);
        MSegmentCache.releaseSharedSegment(text);
        int retValue = p0 + offs;
        if (retValue == p1) {
            --retValue;
        }
        biasReturn[0] = Position.Bias.Forward;
        return retValue;
    }

    public int viewToModelVerticalR2L(MGlyphView v, float x, float y, Shape a, Position.Bias[] biasReturn) {
        this.sync(v);
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int p0 = v.getStartOffset();
        int p1 = v.getEndOffset();
        TabExpander expander = v.getTabExpander();
        Segment text = v.getText(p0, p1);
        int[] justificationData = this.getJustificationData(v);
        int offs = MUtilities.getTabbedTextOffset(v, text, this.metrics, this.defaultmetrics, alloc.y, (int)y, expander, p0, justificationData);
        MSegmentCache.releaseSharedSegment(text);
        int retValue = p0 + offs;
        if (retValue == p1) {
            --retValue;
        }
        biasReturn[0] = Position.Bias.Forward;
        return retValue;
    }

    @Override
    public int getBoundedPosition(MGlyphView v, int p0, float x, float len) {
        this.sync(v);
        TabExpander expander = v.getTabExpander();
        Segment s = v.getText(p0, v.getEndOffset());
        int[] justificationData = this.getJustificationData(v);
        int index = MUtilities.getTabbedTextOffset(v, s, this.metrics, this.defaultmetrics, (int)x, (int)(x + len), expander, p0, false, justificationData);
        MSegmentCache.releaseSharedSegment(s);
        int p1 = p0 + index;
        return p1;
    }

    void sync(MGlyphView v) {
        Container c = v.getContainer();
        Font font = v.getFont();
        if (this.metrics == null || !font.equals(this.metrics.getFont())) {
            this.metrics = c != null ? c.getFontMetrics(font) : Toolkit.getDefaultToolkit().getFontMetrics(font);
        }
        Font alternative_font = MongolianFontUtil.getAltFont(font, "TextField.font");
        this.defaultmetrics = c.getFontMetrics(alternative_font);
        if (!MongolianFontUtil.isMongolianFont(font)) {
            FontMetrics tmpfont = this.metrics;
            this.metrics = this.defaultmetrics;
            this.defaultmetrics = tmpfont;
        }
    }

    private int[] getJustificationData(MGlyphView v) {
        View parent = v.getParent();
        int[] ret = null;
        return ret;
    }
}

