/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text;

import com.mongol.encode.MongolianFontUtil;
import com.mongol.swing.plaf.MRotation;
import com.mongol.swing.text.MPlainBoxView;
import com.mongol.swing.text.MSegmentCache;
import com.mongol.swing.text.MStateInvariantError;
import com.mongol.swing.text.MUtilities;
import java.awt.Color;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.lang.ref.SoftReference;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MWrappedPlainView
extends MPlainBoxView
implements TabExpander,
MRotation {
    private int rotate_direction = 0;
    private int rotate_hint = 0;
    float width = 0.0f;
    float height = 0.0f;
    FontMetrics metrics;
    FontMetrics defaultmetrics;
    Segment lineBuffer;
    boolean widthChanging;
    int tabBase;
    int tabSize;
    boolean wordWrap;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;

    public MWrappedPlainView(Element elem) {
        this(elem, false);
    }

    public MWrappedPlainView(Element elem, boolean wordWrap) {
        super(elem, 1);
        this.wordWrap = wordWrap;
    }

    public MWrappedPlainView(Element elem, boolean wordWrap, int axis) {
        super(elem, axis);
        this.wordWrap = wordWrap;
    }

    protected int getTabSize() {
        Integer i = (Integer)this.getDocument().getProperty("tabSize");
        int size = i != null ? i : 8;
        return size;
    }

    protected void drawLine(int p0, int p1, Graphics g, int x, int y) {
        Element lineMap = this.getElement();
        Element line = lineMap.getElement(lineMap.getElementIndex(p0));
        try {
            if (line.isLeaf()) {
                this.drawText(line, p0, p1, g, x, y);
            } else {
                int idx = line.getElementIndex(p0);
                int lastIdx = line.getElementIndex(p1);
                while (idx <= lastIdx) {
                    Element elem = line.getElement(idx);
                    int start = Math.max(elem.getStartOffset(), p0);
                    int end = Math.min(elem.getEndOffset(), p1);
                    x = this.drawText(elem, start, end, g, x, y);
                    ++idx;
                }
            }
        }
        catch (BadLocationException e) {
            throw new MStateInvariantError("Can't render: " + p0 + "," + p1);
        }
    }

    private int drawText(Element elem, int p0, int p1, Graphics g, int x, int y) throws BadLocationException {
        p1 = Math.min(this.getDocument().getLength(), p1);
        AttributeSet attr = elem.getAttributes();
        if (MUtilities.isComposedTextAttributeDefined(attr)) {
            g.setColor(this.unselected);
            x = MUtilities.drawComposedText(this, attr, g, x, y, p0 - elem.getStartOffset(), p1 - elem.getStartOffset());
        } else if (this.sel0 == this.sel1 || this.selected == this.unselected) {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        } else if (p0 >= this.sel0 && p0 <= this.sel1 && p1 >= this.sel0 && p1 <= this.sel1) {
            x = this.drawSelectedText(g, x, y, p0, p1);
        } else if (this.sel0 >= p0 && this.sel0 <= p1) {
            if (this.sel1 >= p0 && this.sel1 <= p1) {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, this.sel1);
                x = this.drawUnselectedText(g, x, y, this.sel1, p1);
            } else {
                x = this.drawUnselectedText(g, x, y, p0, this.sel0);
                x = this.drawSelectedText(g, x, y, this.sel0, p1);
            }
        } else if (this.sel1 >= p0 && this.sel1 <= p1) {
            x = this.drawSelectedText(g, x, y, p0, this.sel1);
            x = this.drawUnselectedText(g, x, y, this.sel1, p1);
        } else {
            x = this.drawUnselectedText(g, x, y, p0, p1);
        }
        return x;
    }

    protected int drawUnselectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.unselected);
        Document doc = this.getDocument();
        Segment segment = MSegmentCache.getSharedSegment();
        doc.getText(p0, p1 - p0, segment);
        int ret = MUtilities.drawTabbedText(this, segment, x, y, g, this, p0);
        MSegmentCache.releaseSharedSegment(segment);
        return ret;
    }

    protected int drawSelectedText(Graphics g, int x, int y, int p0, int p1) throws BadLocationException {
        g.setColor(this.selected);
        Document doc = this.getDocument();
        Segment segment = MSegmentCache.getSharedSegment();
        doc.getText(p0, p1 - p0, segment);
        int ret = MUtilities.drawTabbedText(this, segment, x, y, g, this, p0);
        MSegmentCache.releaseSharedSegment(segment);
        return ret;
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    protected int calculateBreakPosition(int p0, int p1) {
        int p;
        if (this.rotate_direction == 0) {
            Segment segment = MSegmentCache.getSharedSegment();
            this.loadText(segment, p0, p1);
            int currentWidth = this.getWidth();
            p = this.wordWrap ? p0 + MUtilities.getBreakLocation(segment, this.metrics, this.defaultmetrics, this.tabBase, this.tabBase + currentWidth, this, p0) : p0 + MUtilities.getTabbedTextOffset(segment, this.metrics, this.defaultmetrics, this.tabBase, this.tabBase + currentWidth, this, p0, false);
            MSegmentCache.releaseSharedSegment(segment);
        } else {
            Segment segment = MSegmentCache.getSharedSegment();
            this.loadText(segment, p0, p1);
            int currentWidth = this.getHeight();
            p = this.wordWrap ? p0 + MUtilities.getBreakLocation(segment, this.metrics, this.defaultmetrics, this.tabBase, this.tabBase + currentWidth, this, p0) : p0 + MUtilities.getTabbedTextOffset(segment, this.metrics, this.defaultmetrics, this.tabBase, this.tabBase + currentWidth, this, p0, false);
            MSegmentCache.releaseSharedSegment(segment);
        }
        return p;
    }

    @Override
    protected void loadChildren(ViewFactory f) {
        Element e = this.getElement();
        int n = e.getElementCount();
        if (n > 0) {
            View[] added = new View[n];
            int i = 0;
            while (i < n) {
                added[i] = new MWrappedLine(e.getElement(i));
                ++i;
            }
            this.replace(0, 0, added);
        }
    }

    void updateChildren(DocumentEvent e, Shape a) {
        Element elem = this.getElement();
        DocumentEvent.ElementChange ec = e.getChange(elem);
        if (ec != null) {
            Element[] removedElems = ec.getChildrenRemoved();
            Element[] addedElems = ec.getChildrenAdded();
            View[] added = new View[addedElems.length];
            int i = 0;
            while (i < addedElems.length) {
                added[i] = new MWrappedLine(addedElems[i]);
                ++i;
            }
            this.replace(ec.getIndex(), removedElems.length, added);
            if (a != null) {
                this.preferenceChanged(null, true, true);
                this.getContainer().repaint();
            }
        }
        this.updateMetrics();
    }

    final void loadText(Segment segment, int p0, int p1) {
        try {
            Document doc = this.getDocument();
            doc.getText(p0, p1 - p0, segment);
        }
        catch (BadLocationException bl) {
            throw new MStateInvariantError("Can't get line text");
        }
    }

    final void updateMetrics() {
        Container host = this.getContainer();
        Font font = host.getFont();
        this.metrics = host.getFontMetrics(font);
        Font alternative_font = MongolianFontUtil.getAltFont(font, "TextField.font");
        this.defaultmetrics = host.getFontMetrics(alternative_font);
        if (!MongolianFontUtil.isMongolianFont(font)) {
            FontMetrics tmpfont = this.metrics;
            this.metrics = this.defaultmetrics;
            this.defaultmetrics = tmpfont;
        }
        this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        if (this.tabSize == 0) {
            return x;
        }
        int ntabs = ((int)x - this.tabBase) / this.tabSize;
        return this.tabBase + (ntabs + 1) * this.tabSize;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        Rectangle alloc = (Rectangle)a;
        this.tabBase = alloc.x;
        JTextComponent host = (JTextComponent)this.getContainer();
        this.sel0 = host.getSelectionStart();
        this.sel1 = host.getSelectionEnd();
        this.unselected = host.isEnabled() ? host.getForeground() : host.getDisabledTextColor();
        Caret c = host.getCaret();
        this.selected = c.isSelectionVisible() && host.getHighlighter() != null ? host.getSelectedTextColor() : this.unselected;
        g.setFont(host.getFont());
        super.paint(g, a);
    }

    @Override
    public void setSize(float width, float height) {
        this.width = width;
        this.height = height;
        this.updateMetrics();
        if ((int)width != this.getWidth()) {
            this.preferenceChanged(null, true, true);
            this.widthChanging = true;
        }
        super.setSize(width, height);
        this.widthChanging = false;
    }

    @Override
    public float getPreferredSpan(int axis) {
        this.updateMetrics();
        if (this.rotate_direction == 0) {
            return super.getPreferredSpan(axis);
        }
        if (axis == 0) {
            return super.getPreferredSpan(1);
        }
        return super.getPreferredSpan(0);
    }

    @Override
    public float getMinimumSpan(int axis) {
        this.updateMetrics();
        if (this.rotate_direction == 0) {
            return super.getMinimumSpan(axis);
        }
        if (axis == 0) {
            return super.getMinimumSpan(1);
        }
        return super.getMinimumSpan(0);
    }

    @Override
    public float getMaximumSpan(int axis) {
        this.updateMetrics();
        if (this.rotate_direction == 0) {
            return super.getMaximumSpan(axis);
        }
        if (axis == 0) {
            return super.getMaximumSpan(1);
        }
        return super.getMaximumSpan(0);
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateChildren(e, a);
        Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        int pos = e.getOffset();
        View v = this.getViewAtPosition(pos, alloc);
        if (v != null) {
            v.insertUpdate(e, alloc, f);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateChildren(e, a);
        Rectangle alloc = a != null && this.isAllocationValid() ? this.getInsideAllocation(a) : null;
        int pos = e.getOffset();
        View v = this.getViewAtPosition(pos, alloc);
        if (v != null) {
            v.removeUpdate(e, alloc, f);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        this.updateChildren(e, a);
    }

    @Override
    protected int getOffset(int axis, int childIndex) {
        if (this.rotate_direction == 0) {
            return super.getOffset(axis, childIndex);
        }
        if (axis == 0) {
            return super.getOffset(1, childIndex);
        }
        return super.getOffset(0, childIndex);
    }

    @Override
    protected int getSpan(int axis, int childIndex) {
        if (this.rotate_direction == 0) {
            return super.getSpan(axis, childIndex);
        }
        if (axis == 0) {
            return super.getSpan(1, childIndex);
        }
        return super.getSpan(0, childIndex);
    }

    @Override
    protected void childAllocation(int index, Rectangle alloc) {
        alloc.x += this.getOffset(0, index);
        alloc.y += this.getOffset(1, index);
        alloc.width = this.getSpan(0, index);
        alloc.height = this.getSpan(1, index);
    }

    @Override
    public void setRotateHint(int hint) {
        this.rotate_hint = hint;
    }

    @Override
    public int getRotateHint() {
        return this.rotate_hint;
    }

    @Override
    public void setRotateDirection(int direction) {
        this.rotate_direction = direction;
    }

    @Override
    public int getRotateDirection() {
        return this.rotate_direction;
    }

    @Override
    protected SizeRequirements calculateMajorAxisRequirements(int axis, SizeRequirements r) {
        float min = 0.0f;
        float pref = 0.0f;
        float max = 0.0f;
        if (this.rotate_direction == 0) {
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                min += v.getMinimumSpan(axis);
                pref += v.getPreferredSpan(axis);
                max += v.getMaximumSpan(axis);
                ++i;
            }
            if (r == null) {
                r = new SizeRequirements();
            }
            r.alignment = 0.5f;
            r.minimum = (int)min;
            r.preferred = (int)pref;
            r.maximum = (int)max;
            return r;
        }
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View v = this.getView(i);
            min += v.getMinimumSpan(axis);
            pref += v.getPreferredSpan(axis);
            max += v.getMaximumSpan(axis);
            ++i;
        }
        if (r == null) {
            r = new SizeRequirements();
        }
        r.alignment = 0.5f;
        r.minimum = (int)min;
        r.preferred = (int)pref;
        r.maximum = (int)max;
        return r;
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        int min = 0;
        long pref = 0L;
        int max = Integer.MAX_VALUE;
        if (this.rotate_direction == 0) {
            int n = this.getViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getView(i);
                min = Math.max((int)v.getMinimumSpan(axis), min);
                pref = Math.max((long)((int)v.getPreferredSpan(axis)), pref);
                max = Math.max((int)v.getMaximumSpan(axis), max);
                ++i;
            }
            if (r == null) {
                r = new SizeRequirements();
                r.alignment = 0.5f;
            }
            r.preferred = (int)pref;
            r.minimum = min;
            r.maximum = max;
            return r;
        }
        int n = this.getViewCount();
        int i = 0;
        while (i < n) {
            View v = this.getView(i);
            min = Math.max((int)v.getMinimumSpan(axis), min);
            pref = Math.max((long)((int)v.getPreferredSpan(axis)), pref);
            max = Math.max((int)v.getMaximumSpan(axis), max);
            ++i;
        }
        if (r == null) {
            r = new SizeRequirements();
            r.alignment = 0.5f;
        }
        r.preferred = (int)pref;
        r.minimum = min;
        r.maximum = max;
        return r;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        if (!this.isAllocationValid()) {
            Rectangle alloc = a.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        if (this.rotate_direction == 0) {
            return this.modelToViewHorizantal(pos, a, b);
        }
        if (this.rotate_hint != 4) {
            return this.modelToViewVerticalL2R(pos, a, b);
        }
        return this.modelToViewVerticalR2L(pos, a, b);
    }

    private Shape modelToViewHorizantal(int pos, Shape a, Position.Bias b) throws BadLocationException {
        View v;
        int testPos;
        boolean isBackward = b == Position.Bias.Backward;
        int n = testPos = isBackward ? Math.max(0, pos - 1) : pos;
        if (isBackward && testPos < this.getStartOffset()) {
            return null;
        }
        int vIndex = this.getViewIndexAtPosition(testPos);
        if (vIndex != -1 && vIndex < this.getViewCount() && (v = this.getView(vIndex)) != null && testPos >= v.getStartOffset() && testPos < v.getEndOffset()) {
            Shape childShape = this.getChildAllocation(vIndex, a);
            if (childShape == null) {
                return null;
            }
            Shape retShape = v.modelToView(pos, childShape, b);
            if (retShape == null && v.getEndOffset() == pos && ++vIndex < this.getViewCount()) {
                v = this.getView(vIndex);
                retShape = v.modelToView(pos, this.getChildAllocation(vIndex, a), b);
            }
            return retShape;
        }
        throw new BadLocationException("Position not represented by view", pos);
    }

    private Shape modelToViewVerticalL2R(int pos, Shape a, Position.Bias b) throws BadLocationException {
        View v;
        int testPos;
        boolean isBackward = b == Position.Bias.Backward;
        int n = testPos = isBackward ? Math.max(0, pos - 1) : pos;
        if (isBackward && testPos < this.getStartOffset()) {
            return null;
        }
        int vIndex = this.getViewIndexAtPosition(testPos);
        if (vIndex != -1 && vIndex < this.getViewCount() && (v = this.getView(vIndex)) != null && testPos >= v.getStartOffset() && testPos < v.getEndOffset()) {
            Shape childShape = this.getChildAllocation(vIndex, a);
            if (childShape == null) {
                return null;
            }
            Shape retShape = v.modelToView(pos, childShape, b);
            if (retShape == null && v.getEndOffset() == pos && ++vIndex < this.getViewCount()) {
                v = this.getView(vIndex);
                retShape = v.modelToView(pos, this.getChildAllocation(vIndex, a), b);
            }
            Rectangle alloc = retShape.getBounds();
            JTextComponent c = (JTextComponent)this.getContainer();
            c.putClientProperty("caretWidth", new Integer(alloc.width));
            c.repaint();
            return retShape;
        }
        throw new BadLocationException("Position not represented by view", pos);
    }

    private Shape modelToViewVerticalR2L(int pos, Shape a, Position.Bias b) throws BadLocationException {
        View v;
        int testPos;
        boolean isBackward = b == Position.Bias.Backward;
        int n = testPos = isBackward ? Math.max(0, pos - 1) : pos;
        if (isBackward && testPos < this.getStartOffset()) {
            return null;
        }
        int vIndex = this.getViewIndexAtPosition(testPos);
        if (vIndex != -1 && vIndex < this.getViewCount() && (v = this.getView(vIndex)) != null && testPos >= v.getStartOffset() && testPos < v.getEndOffset()) {
            Shape childShape = this.getChildAllocation(vIndex, a);
            if (childShape == null) {
                return null;
            }
            Shape retShape = v.modelToView(pos, childShape, b);
            if (retShape == null && v.getEndOffset() == pos && ++vIndex < this.getViewCount()) {
                v = this.getView(vIndex);
                retShape = v.modelToView(pos, this.getChildAllocation(vIndex, a), b);
            }
            Rectangle alloc = retShape.getBounds();
            JTextComponent c = (JTextComponent)this.getContainer();
            c.putClientProperty("caretWidth", new Integer(alloc.width));
            c.repaint();
            return retShape;
        }
        throw new BadLocationException("Position not represented by view", pos);
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        if (!this.isAllocationValid()) {
            Rectangle alloc = a.getBounds();
            this.setSize(alloc.width, alloc.height);
        }
        if (this.rotate_direction == 0) {
            return this.viewToModelHorizantal(x, y, a, bias);
        }
        if (this.rotate_hint != 4) {
            return this.viewToModelVerticalL2R(x, y, a, bias);
        }
        return this.viewToModelVerticalR2L(x, y, a, bias);
    }

    private int viewToModelHorizantal(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = this.getInsideAllocation(a);
        if (this.isBefore((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 3, bias);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (retValue == -1) {
                retValue = this.getStartOffset();
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        if (this.isAfter((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 7, bias);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (retValue == -1) {
                retValue = this.getEndOffset() - 1;
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        View v = this.getViewAtPoint((int)x, (int)y, alloc);
        if (v != null) {
            return v.viewToModel(x, y, alloc, bias);
        }
        return -1;
    }

    private int viewToModelVerticalL2R(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = this.getInsideAllocation(a);
        if (this.isBefore((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 3, bias);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (retValue == -1) {
                retValue = this.getStartOffset();
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        if (this.isAfter((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 7, bias);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (retValue == -1) {
                retValue = this.getEndOffset() - 1;
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        View v = this.getViewAtPoint((int)x, (int)y, alloc);
        if (v != null) {
            return v.viewToModel(x, y, alloc, bias);
        }
        return -1;
    }

    private int viewToModelVerticalR2L(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = this.getInsideAllocation(a);
        if (this.isAfter((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 3, bias);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (retValue == -1) {
                retValue = this.getStartOffset();
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        if (this.isBefore((int)x, (int)y, alloc)) {
            int retValue = -1;
            try {
                retValue = this.getNextVisualPositionFrom(-1, Position.Bias.Forward, a, 7, bias);
            }
            catch (BadLocationException badLocationException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (retValue == -1) {
                retValue = this.getEndOffset() - 1;
                bias[0] = Position.Bias.Forward;
            }
            return retValue;
        }
        View v = this.getViewAtPoint((int)x, (int)y, alloc);
        if (v != null) {
            return v.viewToModel(x, y, alloc, bias);
        }
        return -1;
    }

    @Override
    public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        if (this.rotate_direction == 0) {
            return this.modelToViewHorizantal(p0, b0, p1, b1, a);
        }
        if (this.rotate_hint != 4) {
            return this.modelToViewVerticalL2R(p0, b0, p1, b1, a);
        }
        return this.modelToViewVerticalR2L(p0, b0, p1, b1, a);
    }

    private Shape modelToViewHorizantal(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle r1;
        View v1;
        Rectangle alloc;
        Rectangle r0;
        if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
            return a;
        }
        View v0 = this.getViewAtPosition(b0 == Position.Bias.Backward ? Math.max(0, p0 - 1) : p0, r0 = new Rectangle(alloc = this.getInsideAllocation(a)));
        if (v0 == (v1 = this.getViewAtPosition(b1 == Position.Bias.Backward ? Math.max(0, p1 - 1) : p1, r1 = new Rectangle(alloc)))) {
            if (v0 == null) {
                return a;
            }
            return v0.modelToView(p0, b0, p1, b1, r0);
        }
        int viewCount = this.getViewCount();
        int counter = 0;
        while (counter < viewCount) {
            View v = this.getView(counter);
            if (v == v0 || v == v1) {
                View endView;
                Rectangle retRect;
                Rectangle tempRect = new Rectangle();
                if (v == v0) {
                    retRect = v0.modelToView(p0, b0, v0.getEndOffset(), Position.Bias.Backward, r0).getBounds();
                    endView = v1;
                } else {
                    retRect = v1.modelToView(v1.getStartOffset(), Position.Bias.Forward, p1, b1, r1).getBounds();
                    endView = v0;
                }
                while (++counter < viewCount && (v = this.getView(counter)) != endView) {
                    tempRect.setBounds(alloc);
                    this.childAllocation(counter, tempRect);
                    retRect.add(tempRect);
                }
                if (endView != null) {
                    Shape endShape = endView == v1 ? v1.modelToView(v1.getStartOffset(), Position.Bias.Forward, p1, b1, r1) : v0.modelToView(p0, b0, v0.getEndOffset(), Position.Bias.Backward, r0);
                    if (endShape instanceof Rectangle) {
                        retRect.add((Rectangle)endShape);
                    } else {
                        retRect.add(endShape.getBounds());
                    }
                }
                return retRect;
            }
            ++counter;
        }
        throw new BadLocationException("Position not represented by view", p0);
    }

    private Shape modelToViewVerticalL2R(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
            return a;
        }
        Rectangle alloc = this.getInsideAllocation(a);
        Rectangle r0 = new Rectangle(alloc);
        View v0 = this.getViewAtPosition(b0 == Position.Bias.Backward ? Math.max(0, p0 - 1) : p0, r0);
        int tmp = r0.x;
        r0.x = r0.y;
        r0.y = tmp;
        tmp = r0.width;
        r0.width = r0.height;
        r0.height = tmp;
        Rectangle r1 = new Rectangle(alloc);
        View v1 = this.getViewAtPosition(b1 == Position.Bias.Backward ? Math.max(0, p1 - 1) : p1, r1);
        tmp = r1.x;
        r1.x = r1.y;
        r1.y = tmp;
        tmp = r1.width;
        r1.width = r1.height;
        r1.height = tmp;
        if (v0 == v1) {
            if (v0 == null) {
                return a;
            }
            return v0.modelToView(p0, b0, p1, b1, r0);
        }
        int viewCount = this.getViewCount();
        int counter = 0;
        while (counter < viewCount) {
            View v = this.getView(counter);
            if (v == v0 || v == v1) {
                View endView;
                Rectangle retRect;
                Rectangle tempRect = new Rectangle();
                if (v == v0) {
                    retRect = v0.modelToView(p0, b0, v0.getEndOffset(), Position.Bias.Backward, r0).getBounds();
                    endView = v1;
                } else {
                    retRect = v1.modelToView(v1.getStartOffset(), Position.Bias.Forward, p1, b1, r1).getBounds();
                    endView = v0;
                }
                while (++counter < viewCount && (v = this.getView(counter)) != endView) {
                    tempRect.setBounds(alloc);
                    this.childAllocation(counter, tempRect);
                    retRect.add(tempRect);
                }
                if (endView != null) {
                    Shape endShape = endView == v1 ? v1.modelToView(v1.getStartOffset(), Position.Bias.Forward, p1, b1, r1) : v0.modelToView(p0, b0, v0.getEndOffset(), Position.Bias.Backward, r0);
                    if (endShape instanceof Rectangle) {
                        retRect.add((Rectangle)endShape);
                    } else {
                        retRect.add(endShape.getBounds());
                    }
                }
                return retRect;
            }
            ++counter;
        }
        throw new BadLocationException("Position not represented by view", p0);
    }

    private Shape modelToViewVerticalR2L(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
        Rectangle r1;
        View v1;
        Rectangle alloc;
        Rectangle r0;
        if (p0 == this.getStartOffset() && p1 == this.getEndOffset()) {
            return a;
        }
        View v0 = this.getViewAtPosition(b0 == Position.Bias.Backward ? Math.max(0, p0 - 1) : p0, r0 = new Rectangle(alloc = this.getInsideAllocation(a)));
        if (v0 == (v1 = this.getViewAtPosition(b1 == Position.Bias.Backward ? Math.max(0, p1 - 1) : p1, r1 = new Rectangle(alloc)))) {
            if (v0 == null) {
                return a;
            }
            return v0.modelToView(p0, b0, p1, b1, r0);
        }
        int viewCount = this.getViewCount();
        int counter = 0;
        while (counter < viewCount) {
            View v = this.getView(counter);
            if (v == v0 || v == v1) {
                View endView;
                Rectangle retRect;
                Rectangle tempRect = new Rectangle();
                if (v == v0) {
                    retRect = v0.modelToView(p0, b0, v0.getEndOffset(), Position.Bias.Backward, r0).getBounds();
                    endView = v1;
                } else {
                    retRect = v1.modelToView(v1.getStartOffset(), Position.Bias.Forward, p1, b1, r1).getBounds();
                    endView = v0;
                }
                while (++counter < viewCount && (v = this.getView(counter)) != endView) {
                    tempRect.setBounds(alloc);
                    this.childAllocation(counter, tempRect);
                    retRect.add(tempRect);
                }
                if (endView != null) {
                    Shape endShape = endView == v1 ? v1.modelToView(v1.getStartOffset(), Position.Bias.Forward, p1, b1, r1) : v0.modelToView(p0, b0, v0.getEndOffset(), Position.Bias.Backward, r0);
                    if (endShape instanceof Rectangle) {
                        retRect.add((Rectangle)endShape);
                    } else {
                        retRect.add(endShape.getBounds());
                    }
                }
                return retRect;
            }
            ++counter;
        }
        throw new BadLocationException("Position not represented by view", p0);
    }

    @Override
    protected View getViewAtPoint(int x, int y, Rectangle alloc) {
        int n = this.getViewCount();
        if (this.rotate_direction == 0) {
            if (x < alloc.x + this.majorOffsets[0]) {
                this.childAllocation(0, alloc);
                return this.getView(0);
            }
            int i = 0;
            while (i < n) {
                if (x < alloc.x + this.majorOffsets[i]) {
                    this.childAllocation(i - 1, alloc);
                    return this.getView(i - 1);
                }
                ++i;
            }
            this.childAllocation(n - 1, alloc);
            return this.getView(n - 1);
        }
        if (this.rotate_hint != 4) {
            if (x < alloc.x + this.majorOffsets[0]) {
                this.childAllocation(0, alloc);
                return this.getView(0);
            }
            int i = 0;
            while (i < n) {
                if (x < alloc.x + this.majorOffsets[i]) {
                    this.childAllocation(i - 1, alloc);
                    return this.getView(i - 1);
                }
                ++i;
            }
            this.childAllocation(n - 1, alloc);
            return this.getView(n - 1);
        }
        int w = (int)this.width;
        if (x > alloc.x + w - this.majorOffsets[0]) {
            this.childAllocation(0, alloc);
            return this.getView(0);
        }
        int i = 0;
        while (i < n) {
            if (x > alloc.x + w - this.majorOffsets[i]) {
                this.childAllocation(i - 1, alloc);
                return this.getView(i - 1);
            }
            ++i;
        }
        this.childAllocation(n - 1, alloc);
        return this.getView(n - 1);
    }

    @Override
    public int getNextVisualPositionFrom(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        if (this.rotate_direction == 0) {
            return this.getNextVisualPositionFromHorizantal(pos, b, a, direction, biasRet);
        }
        if (this.rotate_hint != 4) {
            return this.getNextVisualPositionFromVerticalL2R(pos, b, a, direction, biasRet);
        }
        return this.getNextVisualPositionFromVerticalR2L(pos, b, a, direction, biasRet);
    }

    protected int getNextVisualPositionFromHorizantal(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 1: 
            case 5: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 1 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                    break;
                }
                JTextComponent target = (JTextComponent)this.getContainer();
                Caret c = target != null ? target.getCaret() : null;
                Point mcp = c != null ? c.getMagicCaretPosition() : null;
                int x = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 1) {
                    pos = MUtilities.getPositionAbove(target, pos, x);
                    break;
                }
                pos = MUtilities.getPositionBelow(target, pos, x);
                break;
            }
            case 7: {
                if (pos == -1) {
                    pos = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                break;
            }
            case 3: {
                if (pos == -1) {
                    pos = this.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    private int getNextVisualPositionFromVerticalL2R(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 3: 
            case 7: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 7 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                    break;
                }
                JTextComponent target = (JTextComponent)this.getContainer();
                Caret c = target != null ? target.getCaret() : null;
                Point mcp = c != null ? c.getMagicCaretPosition() : null;
                int x = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.x) : mcp.x;
                if (direction == 7) {
                    pos = MUtilities.getPositionAboveL2R(target, pos, x);
                    break;
                }
                pos = MUtilities.getPositionBelowL2R(target, pos, x);
                break;
            }
            case 1: {
                if (pos == -1) {
                    pos = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                break;
            }
            case 5: {
                if (pos == -1) {
                    pos = this.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    private int getNextVisualPositionFromVerticalR2L(int pos, Position.Bias b, Shape a, int direction, Position.Bias[] biasRet) throws BadLocationException {
        if (pos < -1) {
            throw new BadLocationException("Invalid position", pos);
        }
        biasRet[0] = Position.Bias.Forward;
        switch (direction) {
            case 3: 
            case 7: {
                Rectangle loc;
                if (pos == -1) {
                    pos = direction == 3 ? Math.max(0, this.getEndOffset() - 1) : this.getStartOffset();
                    break;
                }
                JTextComponent target = (JTextComponent)this.getContainer();
                Caret c = target != null ? target.getCaret() : null;
                Point mcp = c != null ? c.getMagicCaretPosition() : null;
                int y = mcp == null ? ((loc = target.modelToView(pos)) == null ? 0 : loc.y) : mcp.y;
                if (direction == 3) {
                    pos = MUtilities.getPositionAboveR2L(target, pos, y);
                    break;
                }
                pos = MUtilities.getPositionBelowR2L(target, pos, y);
                break;
            }
            case 1: {
                if (pos == -1) {
                    pos = Math.max(0, this.getEndOffset() - 1);
                    break;
                }
                pos = Math.max(0, pos - 1);
                break;
            }
            case 5: {
                if (pos == -1) {
                    pos = this.getStartOffset();
                    break;
                }
                pos = Math.min(pos + 1, this.getDocument().getLength());
                break;
            }
            default: {
                throw new IllegalArgumentException("Bad direction: " + direction);
            }
        }
        return pos;
    }

    class MWrappedLine
    extends View {
        int lineCount;
        SoftReference<int[]> lineCache;

        MWrappedLine(Element elem) {
            super(elem);
            this.lineCache = null;
            this.lineCount = -1;
        }

        @Override
        public float getPreferredSpan(int axis) {
            if (MWrappedPlainView.this.rotate_direction == 0) {
                switch (axis) {
                    case 0: {
                        float width = MWrappedPlainView.this.getWidth();
                        if (width == 2.1474836E9f) {
                            return 100.0f;
                        }
                        return width;
                    }
                    case 1: {
                        if (this.lineCount < 0 || MWrappedPlainView.this.widthChanging) {
                            this.breakLines(this.getStartOffset());
                        }
                        return this.lineCount * MWrappedPlainView.this.metrics.getHeight();
                    }
                }
                throw new IllegalArgumentException("Invalid axis: " + axis);
            }
            switch (axis) {
                case 1: {
                    float height = MWrappedPlainView.this.getHeight();
                    if (height == 2.1474836E9f) {
                        return 100.0f;
                    }
                    return height;
                }
                case 0: {
                    if (this.lineCount < 0 || MWrappedPlainView.this.widthChanging) {
                        this.breakLines(this.getStartOffset());
                    }
                    return this.lineCount * MWrappedPlainView.this.metrics.getHeight();
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }

        @Override
        public void paint(Graphics g, Shape a) {
            if (MWrappedPlainView.this.getRotateDirection() == 0) {
                this.paintHorizantal(g, a);
            } else if (MWrappedPlainView.this.getRotateHint() != 4) {
                Graphics2D g2d = (Graphics2D)g;
                AffineTransform transform = g2d.getTransform();
                ((Graphics2D)g).rotate(1.5707963267948966);
                this.paintVerticalL2R(g, a);
                g2d.setTransform(transform);
            } else {
                Graphics2D g2d = (Graphics2D)g;
                AffineTransform transform = g2d.getTransform();
                ((Graphics2D)g).rotate(1.5707963267948966);
                float w = MWrappedPlainView.this.width;
                g2d.translate(0.0, -w);
                this.paintVerticalR2L(g, a);
                g2d.setTransform(transform);
            }
        }

        private void paintHorizantal(Graphics g, Shape a) {
            Rectangle alloc = (Rectangle)a;
            int y = alloc.y + MWrappedPlainView.this.metrics.getAscent();
            int x = alloc.x;
            JTextComponent host = (JTextComponent)this.getContainer();
            Highlighter h = host.getHighlighter();
            LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            int p0 = start;
            int[] lineEnds = this.getLineEnds();
            int i = 0;
            while (i < this.lineCount) {
                int p1;
                int n = p1 = lineEnds == null ? end : start + lineEnds[i];
                if (dh != null) {
                    int hOffset = p1 == end ? p1 - 1 : p1;
                    dh.paintLayeredHighlights(g, p0, hOffset, a, host, this);
                }
                MWrappedPlainView.this.drawLine(p0, p1, g, x, y);
                p0 = p1;
                y += MWrappedPlainView.this.metrics.getHeight();
                ++i;
            }
        }

        private void paintVerticalL2R(Graphics g, Shape a) {
            Rectangle alloc = new Rectangle((Rectangle)a);
            int y = -alloc.y;
            int x = alloc.x;
            JTextComponent host = (JTextComponent)this.getContainer();
            Highlighter h = host.getHighlighter();
            LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            int p0 = start;
            int[] lineEnds = this.getLineEnds();
            int i = 0;
            while (i < this.lineCount) {
                int p1;
                int n = p1 = lineEnds == null ? end : start + lineEnds[i];
                if (dh != null) {
                    int hOffset = p1 == end ? p1 - 1 : p1;
                    dh.paintLayeredHighlights(g, p0, hOffset, a, host, this);
                }
                MWrappedPlainView.this.drawLine(p0, p1, g, x, y);
                p0 = p1;
                y -= MWrappedPlainView.this.metrics.getHeight();
                ++i;
            }
        }

        private void paintVerticalR2L(Graphics g, Shape a) {
            Rectangle alloc = (Rectangle)a;
            int y = alloc.y + MWrappedPlainView.this.metrics.getAscent();
            int x = alloc.x;
            JTextComponent host = (JTextComponent)this.getContainer();
            Highlighter h = host.getHighlighter();
            LayeredHighlighter dh = h instanceof LayeredHighlighter ? (LayeredHighlighter)h : null;
            int start = this.getStartOffset();
            int end = this.getEndOffset();
            int p0 = start;
            int[] lineEnds = this.getLineEnds();
            int i = 0;
            while (i < this.lineCount) {
                int p1;
                int n = p1 = lineEnds == null ? end : start + lineEnds[i];
                if (dh != null) {
                    int hOffset = p1 == end ? p1 - 1 : p1;
                    dh.paintLayeredHighlights(g, p0, hOffset, a, host, this);
                }
                MWrappedPlainView.this.drawLine(p0, p1, g, x, y);
                p0 = p1;
                y += MWrappedPlainView.this.metrics.getHeight();
                ++i;
            }
        }

        @Override
        public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
            if (MWrappedPlainView.this.rotate_direction == 0) {
                return this.modelToViewHorizantal(pos, a, b);
            }
            if (MWrappedPlainView.this.rotate_hint != 4) {
                return this.modelToViewVerticalL2R(pos, a, b);
            }
            return this.modelToViewVerticalR2L(pos, a, b);
        }

        private Shape modelToViewHorizantal(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle alloc = a.getBounds();
            alloc.height = MWrappedPlainView.this.metrics.getHeight();
            alloc.width = 1;
            int p0 = this.getStartOffset();
            if (pos < p0 || pos > this.getEndOffset()) {
                throw new BadLocationException("Position out of range", pos);
            }
            int testP = b == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
            int line = 0;
            int[] lineEnds = this.getLineEnds();
            if (lineEnds != null) {
                line = this.findLine(testP - p0);
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
                alloc.y += alloc.height * line;
            }
            if (pos > p0) {
                Segment segment = MSegmentCache.getSharedSegment();
                MWrappedPlainView.this.loadText(segment, p0, pos);
                alloc.x += MUtilities.getTabbedTextWidth(segment, MWrappedPlainView.this.metrics, alloc.x, MWrappedPlainView.this, p0);
                MSegmentCache.releaseSharedSegment(segment);
            }
            return alloc;
        }

        private Shape modelToViewVerticalL2R(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle alloc = a.getBounds();
            int tmp = alloc.x;
            alloc.x = alloc.y;
            alloc.y = tmp;
            alloc.width = MWrappedPlainView.this.metrics.getHeight();
            alloc.height = 1;
            int p0 = this.getStartOffset();
            if (pos < p0 || pos > this.getEndOffset()) {
                throw new BadLocationException("Position out of range", pos);
            }
            int testP = b == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
            int line = 0;
            int[] lineEnds = this.getLineEnds();
            if (lineEnds != null) {
                line = this.findLine(testP - p0);
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
                alloc.x += MWrappedPlainView.this.metrics.getHeight() / 2 + alloc.width * line;
            } else {
                alloc.x += MWrappedPlainView.this.metrics.getHeight() / 2;
            }
            if (pos > p0) {
                Segment segment = MSegmentCache.getSharedSegment();
                MWrappedPlainView.this.loadText(segment, p0, pos);
                alloc.y += MUtilities.getTabbedTextWidth(MWrappedPlainView.this, segment, MWrappedPlainView.this.metrics, MWrappedPlainView.this.defaultmetrics, alloc.y, MWrappedPlainView.this, p0, null);
                MSegmentCache.releaseSharedSegment(segment);
            }
            return alloc;
        }

        private Shape modelToViewVerticalR2L(int pos, Shape a, Position.Bias b) throws BadLocationException {
            Rectangle alloc = a.getBounds();
            int tmp = alloc.x;
            alloc.x = alloc.y;
            alloc.y = tmp;
            alloc.width = MWrappedPlainView.this.metrics.getHeight();
            alloc.height = 1;
            int p0 = this.getStartOffset();
            if (pos < p0 || pos > this.getEndOffset()) {
                throw new BadLocationException("Position out of range", pos);
            }
            int testP = b == Position.Bias.Forward ? pos : Math.max(p0, pos - 1);
            int line = 0;
            int[] lineEnds = this.getLineEnds();
            if (lineEnds != null) {
                line = this.findLine(testP - p0);
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
                alloc.x += MWrappedPlainView.this.metrics.getHeight() / 2 + alloc.width * line;
            } else {
                alloc.x += MWrappedPlainView.this.metrics.getHeight() / 2;
            }
            int w = (int)MWrappedPlainView.this.width;
            alloc.x = w - alloc.x;
            if (pos > p0) {
                Segment segment = MSegmentCache.getSharedSegment();
                MWrappedPlainView.this.loadText(segment, p0, pos);
                alloc.y += MUtilities.getTabbedTextWidth(segment, MWrappedPlainView.this.metrics, alloc.y, MWrappedPlainView.this, p0);
                MSegmentCache.releaseSharedSegment(segment);
            }
            return alloc;
        }

        @Override
        public int viewToModel(float fx, float fy, Shape a, Position.Bias[] bias) {
            if (MWrappedPlainView.this.rotate_direction == 0) {
                return this.viewToModelHorizantal(fx, fy, a, bias);
            }
            if (MWrappedPlainView.this.rotate_hint != 4) {
                return this.viewToModelVerticalL2R(fx, fy, a, bias);
            }
            return this.viewToModelVerticalR2L(fx, fy, a, bias);
        }

        private int viewToModelHorizantal(float fx, float fy, Shape a, Position.Bias[] bias) {
            int p1;
            int line;
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a;
            int x = (int)fx;
            int y = (int)fy;
            if (y < alloc.y) {
                return this.getStartOffset();
            }
            if (y > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            alloc.height = MWrappedPlainView.this.metrics.getHeight();
            int n = line = alloc.height > 0 ? (y - alloc.y) / alloc.height : this.lineCount - 1;
            if (line >= this.lineCount) {
                return this.getEndOffset() - 1;
            }
            int p0 = this.getStartOffset();
            if (this.lineCount == 1) {
                p1 = this.getEndOffset();
            } else {
                int[] lineEnds = this.getLineEnds();
                p1 = p0 + lineEnds[line];
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
            }
            if (x < alloc.x) {
                return p0;
            }
            if (x > alloc.x + alloc.width) {
                return p1 - 1;
            }
            Segment segment = MSegmentCache.getSharedSegment();
            MWrappedPlainView.this.loadText(segment, p0, p1);
            int n2 = MUtilities.getTabbedTextOffset(segment, MWrappedPlainView.this.metrics, alloc.x, x, MWrappedPlainView.this, p0);
            MSegmentCache.releaseSharedSegment(segment);
            return Math.min(p0 + n2, p1 - 1);
        }

        private int viewToModelVerticalL2R(float fx, float fy, Shape a, Position.Bias[] bias) {
            int p1;
            int line;
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = new Rectangle((Rectangle)a);
            int tmp = alloc.x;
            alloc.x = alloc.y;
            alloc.y = tmp;
            tmp = alloc.width;
            alloc.width = alloc.height;
            alloc.height = tmp;
            int x = (int)fx;
            int y = (int)fy;
            if (y < alloc.y) {
                return this.getStartOffset();
            }
            if (y > alloc.y + alloc.height) {
                return this.getEndOffset() - 1;
            }
            alloc.width = MWrappedPlainView.this.metrics.getHeight();
            int n = line = alloc.width > 0 ? (x - alloc.x) / alloc.width : this.lineCount - 1;
            if (line >= this.lineCount) {
                return this.getEndOffset() - 1;
            }
            int p0 = this.getStartOffset();
            if (this.lineCount == 1) {
                p1 = this.getEndOffset();
            } else {
                int[] lineEnds = this.getLineEnds();
                p1 = p0 + lineEnds[line];
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
            }
            if (y < alloc.y) {
                return p0;
            }
            if (y > alloc.y + alloc.height) {
                return p1 - 1;
            }
            Segment segment = MSegmentCache.getSharedSegment();
            MWrappedPlainView.this.loadText(segment, p0, p1);
            int n2 = MUtilities.getTabbedTextOffset(MWrappedPlainView.this, segment, MWrappedPlainView.this.metrics, MWrappedPlainView.this.defaultmetrics, alloc.y, y, MWrappedPlainView.this, p0, null);
            MSegmentCache.releaseSharedSegment(segment);
            return Math.min(p0 + n2, p1 - 1);
        }

        private int viewToModelVerticalR2L(float fx, float fy, Shape a, Position.Bias[] bias) {
            int p1;
            int line;
            bias[0] = Position.Bias.Forward;
            Rectangle alloc = (Rectangle)a;
            int tmp = alloc.x;
            alloc.x = alloc.y;
            alloc.y = tmp;
            tmp = alloc.width;
            alloc.width = alloc.height;
            alloc.height = tmp;
            int x = (int)fx;
            int y = (int)fy;
            if (y < alloc.y) {
                return this.getEndOffset() - 1;
            }
            if (y > alloc.y + alloc.height) {
                return this.getStartOffset();
            }
            alloc.width = MWrappedPlainView.this.metrics.getHeight();
            int w = (int)MWrappedPlainView.this.width;
            int n = line = alloc.width > 0 ? (w - (x += alloc.x)) / alloc.width : this.lineCount - 1;
            if (line >= this.lineCount) {
                return this.getEndOffset() - 1;
            }
            int p0 = this.getStartOffset();
            if (this.lineCount == 1) {
                p1 = this.getEndOffset();
            } else {
                int[] lineEnds = this.getLineEnds();
                p1 = p0 + lineEnds[line];
                if (line > 0) {
                    p0 += lineEnds[line - 1];
                }
            }
            if (y < alloc.y) {
                return p0;
            }
            if (y > alloc.y + alloc.height) {
                return p1 - 1;
            }
            Segment segment = MSegmentCache.getSharedSegment();
            MWrappedPlainView.this.loadText(segment, p0, p1);
            int n2 = MUtilities.getTabbedTextOffset(segment, MWrappedPlainView.this.metrics, alloc.y, y, MWrappedPlainView.this, p0);
            MSegmentCache.releaseSharedSegment(segment);
            return Math.min(p0 + n2, p1 - 1);
        }

        @Override
        public Shape modelToView(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            if (MWrappedPlainView.this.rotate_direction == 0) {
                return this.modelToViewHorizantal(p0, b0, p1, b1, a);
            }
            if (MWrappedPlainView.this.rotate_hint != 4) {
                return this.modelToViewVerticalL2R(p0, b0, p1, b1, a);
            }
            return this.modelToViewVerticalR2L(p0, b0, p1, b1, a);
        }

        private Shape modelToViewHorizantal(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            Rectangle r1;
            Shape s1;
            Shape s0 = this.modelToView(p0, a, b0);
            if (p1 == this.getEndOffset()) {
                try {
                    s1 = this.modelToView(p1, a, b1);
                }
                catch (BadLocationException ble) {
                    s1 = null;
                }
                if (s1 == null) {
                    Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                    s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
                }
            } else {
                s1 = this.modelToView(p1, a, b1);
            }
            Rectangle r0 = s0.getBounds();
            Rectangle rectangle = r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
            if (r0.y != r1.y) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                r0.x = alloc.x;
                r0.width = alloc.width;
            }
            r0.add(r1);
            return r0;
        }

        private Shape modelToViewVerticalL2R(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            Shape s1;
            Shape s0 = this.modelToView(p0, a, b0);
            if (p1 == this.getEndOffset()) {
                try {
                    s1 = this.modelToView(p1, a, b1);
                }
                catch (BadLocationException ble) {
                    s1 = null;
                }
                if (s1 == null) {
                    Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                    s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
                }
            } else {
                s1 = this.modelToView(p1, a, b1);
            }
            Rectangle r0 = s0.getBounds();
            int tmp = r0.x;
            r0.x = r0.y;
            r0.y = -tmp - r0.width / 2;
            tmp = r0.width;
            r0.width = r0.height;
            r0.height = tmp;
            Rectangle r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
            tmp = r1.x;
            r1.x = r1.y;
            r1.y = -tmp - r1.width / 2;
            tmp = r1.width;
            r1.width = r1.height;
            r1.height = tmp;
            if (r0.y != r1.y) {
                Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                r0.x = alloc.x;
                r0.width = alloc.width;
            }
            r0.add(r1);
            return r0;
        }

        private Shape modelToViewVerticalR2L(int p0, Position.Bias b0, int p1, Position.Bias b1, Shape a) throws BadLocationException {
            Rectangle alloc;
            Shape s1;
            Shape s0 = this.modelToView(p0, a, b0);
            if (p1 == this.getEndOffset()) {
                try {
                    s1 = this.modelToView(p1, a, b1);
                }
                catch (BadLocationException ble) {
                    s1 = null;
                }
                if (s1 == null) {
                    alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
                    s1 = new Rectangle(alloc.x + alloc.width - 1, alloc.y, 1, alloc.height);
                }
            } else {
                s1 = this.modelToView(p1, a, b1);
            }
            alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
            int w = (int)MWrappedPlainView.this.width;
            Rectangle r0 = s0.getBounds();
            int tmp = r0.x;
            r0.x = r0.y;
            r0.y = w - (tmp + r0.width / 2);
            tmp = r0.width;
            r0.width = r0.height;
            r0.height = tmp;
            Rectangle r1 = s1 instanceof Rectangle ? (Rectangle)s1 : s1.getBounds();
            tmp = r1.x;
            r1.x = r1.y;
            r1.y = w - (tmp + r1.width / 2);
            tmp = r1.width;
            r1.width = r1.height;
            r1.height = tmp;
            if (r0.y != r1.y) {
                r0.x = alloc.x;
                r0.width = alloc.width;
            }
            r0.add(r1);
            return r0;
        }

        @Override
        public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.update(e, a);
        }

        @Override
        public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
            this.update(e, a);
        }

        private void update(DocumentEvent ev, Shape a) {
            int oldCount = this.lineCount;
            this.breakLines(ev.getOffset());
            if (oldCount != this.lineCount) {
                MWrappedPlainView.this.preferenceChanged(this, false, true);
                this.getContainer().repaint();
            } else if (a != null) {
                Container c = this.getContainer();
                Rectangle alloc = (Rectangle)a;
                c.repaint(alloc.x, alloc.y, alloc.width, alloc.height);
            }
        }

        final int[] getLineEnds() {
            if (this.lineCache == null) {
                return null;
            }
            int[] lineEnds = this.lineCache.get();
            if (lineEnds == null) {
                return this.breakLines(this.getStartOffset());
            }
            return lineEnds;
        }

        final int[] breakLines(int startPos) {
            int maxCapacity;
            int[] lineEnds;
            int[] oldLineEnds = lineEnds = this.lineCache == null ? null : this.lineCache.get();
            int start = this.getStartOffset();
            int lineIndex = 0;
            if (lineEnds != null && (lineIndex = this.findLine(startPos - start)) > 0) {
                --lineIndex;
            }
            int p0 = lineIndex == 0 ? start : start + lineEnds[lineIndex - 1];
            int p1 = this.getEndOffset();
            while (p0 < p1) {
                int p = MWrappedPlainView.this.calculateBreakPosition(p0, p1);
                int n = p0 = p == p0 ? ++p : p;
                if (lineIndex == 0 && p0 >= p1) {
                    this.lineCache = null;
                    lineEnds = null;
                    lineIndex = 1;
                    break;
                }
                if (lineEnds == null || lineIndex >= lineEnds.length) {
                    double growFactor = (double)(p1 - start) / (double)(p0 - start);
                    int newSize = (int)Math.ceil((double)(lineIndex + 1) * growFactor);
                    newSize = Math.max(newSize, lineIndex + 2);
                    int[] tmp = new int[newSize];
                    if (lineEnds != null) {
                        System.arraycopy(lineEnds, 0, tmp, 0, lineIndex);
                    }
                    lineEnds = tmp;
                }
                lineEnds[lineIndex++] = p0 - start;
            }
            this.lineCount = lineIndex;
            if (this.lineCount > 1 && lineEnds.length > (maxCapacity = this.lineCount + this.lineCount / 3)) {
                int[] tmp = new int[maxCapacity];
                System.arraycopy(lineEnds, 0, tmp, 0, this.lineCount);
                lineEnds = tmp;
            }
            if (lineEnds != null && lineEnds != oldLineEnds) {
                this.lineCache = new SoftReference<int[]>(lineEnds);
            }
            return lineEnds;
        }

        private int findLine(int offset) {
            int[] lineEnds = this.lineCache.get();
            if (offset < lineEnds[0]) {
                return 0;
            }
            if (offset > lineEnds[this.lineCount - 1]) {
                return this.lineCount;
            }
            return this.findLine(lineEnds, offset, 0, this.lineCount - 1);
        }

        private int findLine(int[] array, int offset, int min, int max) {
            if (max - min <= 1) {
                return max;
            }
            int mid = (max + min) / 2;
            return offset < array[mid] ? this.findLine(array, offset, min, mid) : this.findLine(array, offset, mid, max);
        }
    }
}

