/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MFrameView;
import com.mongol.swing.text.html.MHTML;
import java.util.StringTokenizer;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;

public class MFrameSetView
extends BoxView {
    String[] children = null;
    int[] percentChildren;
    int[] absoluteChildren;
    int[] relativeChildren;
    int percentTotals;
    int absoluteTotals;
    int relativeTotals;

    public MFrameSetView(Element elem, int axis) {
        super(elem, axis);
    }

    private String[] parseRowColSpec(MHTML.Attribute key) {
        AttributeSet attributes = this.getElement().getAttributes();
        String spec = "*";
        if (attributes != null && attributes.getAttribute(key) != null) {
            spec = (String)attributes.getAttribute(key);
        }
        StringTokenizer tokenizer = new StringTokenizer(spec, ",");
        int nTokens = tokenizer.countTokens();
        int n = this.getViewCount();
        String[] items = new String[Math.max(nTokens, n)];
        int i = 0;
        while (i < nTokens) {
            items[i] = tokenizer.nextToken().trim();
            if (items[i].equals("100%")) {
                items[i] = "*";
            }
            ++i;
        }
        while (i < items.length) {
            items[i] = "*";
            ++i;
        }
        return items;
    }

    private void init() {
        this.children = this.getAxis() == 1 ? this.parseRowColSpec(MHTML.Attribute.ROWS) : this.parseRowColSpec(MHTML.Attribute.COLS);
        this.percentChildren = new int[this.children.length];
        this.relativeChildren = new int[this.children.length];
        this.absoluteChildren = new int[this.children.length];
        int i = 0;
        while (i < this.children.length) {
            this.percentChildren[i] = -1;
            this.relativeChildren[i] = -1;
            this.absoluteChildren[i] = -1;
            if (this.children[i].endsWith("*")) {
                if (this.children[i].length() > 1) {
                    this.relativeChildren[i] = Integer.parseInt(this.children[i].substring(0, this.children[i].length() - 1));
                    this.relativeTotals += this.relativeChildren[i];
                } else {
                    this.relativeChildren[i] = 1;
                    ++this.relativeTotals;
                }
            } else if (this.children[i].indexOf(37) != -1) {
                this.percentChildren[i] = this.parseDigits(this.children[i]);
                this.percentTotals += this.percentChildren[i];
            } else {
                this.absoluteChildren[i] = Integer.parseInt(this.children[i]);
            }
            ++i;
        }
        if (this.percentTotals > 100) {
            i = 0;
            while (i < this.percentChildren.length) {
                if (this.percentChildren[i] > 0) {
                    this.percentChildren[i] = this.percentChildren[i] * 100 / this.percentTotals;
                }
                ++i;
            }
            this.percentTotals = 100;
        }
    }

    @Override
    protected void layoutMajorAxis(int targetSpan, int axis, int[] offsets, int[] spans) {
        if (this.children == null) {
            this.init();
        }
        SizeRequirements.calculateTiledPositions(targetSpan, null, this.getChildRequests(targetSpan, axis), offsets, spans);
    }

    protected SizeRequirements[] getChildRequests(int targetSpan, int axis) {
        int[] span = new int[this.children.length];
        this.spread(targetSpan, span);
        int n = this.getViewCount();
        SizeRequirements[] reqs = new SizeRequirements[n];
        int i = 0;
        int sIndex = 0;
        while (i < n) {
            View v = this.getView(i);
            if (v instanceof MFrameView || v instanceof MFrameSetView) {
                reqs[i] = new SizeRequirements((int)v.getMinimumSpan(axis), span[sIndex], (int)v.getMaximumSpan(axis), 0.5f);
                ++sIndex;
            } else {
                int min = (int)v.getMinimumSpan(axis);
                int pref = (int)v.getPreferredSpan(axis);
                int max = (int)v.getMaximumSpan(axis);
                float a = v.getAlignment(axis);
                reqs[i] = new SizeRequirements(min, pref, max, a);
            }
            ++i;
        }
        return reqs;
    }

    private void spread(int targetSpan, int[] span) {
        block14: {
            int remainingSpace;
            block13: {
                if (targetSpan == 0) {
                    return;
                }
                int tempSpace = 0;
                remainingSpace = targetSpan;
                int i = 0;
                while (i < span.length) {
                    if (this.absoluteChildren[i] > 0) {
                        span[i] = this.absoluteChildren[i];
                        remainingSpace -= span[i];
                    }
                    ++i;
                }
                tempSpace = remainingSpace;
                i = 0;
                while (i < span.length) {
                    if (this.percentChildren[i] > 0 && tempSpace > 0) {
                        span[i] = this.percentChildren[i] * tempSpace / 100;
                        remainingSpace -= span[i];
                    } else if (this.percentChildren[i] > 0 && tempSpace <= 0) {
                        span[i] = targetSpan / span.length;
                        remainingSpace -= span[i];
                    }
                    ++i;
                }
                if (remainingSpace <= 0 || this.relativeTotals <= 0) break block13;
                i = 0;
                while (i < span.length) {
                    if (this.relativeChildren[i] > 0) {
                        span[i] = remainingSpace * this.relativeChildren[i] / this.relativeTotals;
                    }
                    ++i;
                }
                break block14;
            }
            if (remainingSpace <= 0) break block14;
            float vTotal = targetSpan - remainingSpace;
            float[] tempPercents = new float[span.length];
            remainingSpace = targetSpan;
            int i = 0;
            while (i < span.length) {
                tempPercents[i] = (float)span[i] / vTotal * 100.0f;
                span[i] = (int)((float)targetSpan * tempPercents[i] / 100.0f);
                remainingSpace -= span[i];
                ++i;
            }
            i = 0;
            while (remainingSpace != 0) {
                if (remainingSpace < 0) {
                    int n = i++;
                    span[n] = span[n] - 1;
                    ++remainingSpace;
                } else {
                    int n = i++;
                    span[n] = span[n] + 1;
                    --remainingSpace;
                }
                if (i != span.length) continue;
                i = 0;
            }
        }
    }

    private int parseDigits(String mixedStr) {
        int result = 0;
        int i = 0;
        while (i < mixedStr.length()) {
            char ch = mixedStr.charAt(i);
            if (Character.isDigit(ch)) {
                result = result * 10 + Character.digit(ch, 10);
            }
            ++i;
        }
        return result;
    }
}

