/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MCSS;
import com.mongol.swing.text.html.MHTML;
import com.mongol.swing.text.html.MHTMLDocument;
import com.mongol.swing.text.html.MStyleSheet;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StyleConstants;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

class MHRuleView
extends View {
    private float topMargin;
    private float bottomMargin;
    private float leftMargin;
    private float rightMargin;
    private int alignment = 1;
    private String noshade = null;
    private int size = 0;
    private MCSS.LengthValue widthValue;
    private static final int SPACE_ABOVE = 3;
    private static final int SPACE_BELOW = 3;
    private AttributeSet attr;

    public MHRuleView(Element elem) {
        super(elem);
        this.setPropertiesFromAttributes();
    }

    protected void setPropertiesFromAttributes() {
        MStyleSheet sheet = ((MHTMLDocument)this.getDocument()).getStyleSheet();
        AttributeSet eAttr = this.getElement().getAttributes();
        this.attr = sheet.getViewAttributes(this);
        this.alignment = 1;
        this.size = 0;
        this.noshade = null;
        this.widthValue = null;
        if (this.attr != null) {
            if (this.attr.getAttribute(StyleConstants.Alignment) != null) {
                this.alignment = StyleConstants.getAlignment(this.attr);
            }
            this.noshade = (String)eAttr.getAttribute(MHTML.Attribute.NOSHADE);
            Object value = eAttr.getAttribute(MHTML.Attribute.SIZE);
            if (value != null && value instanceof String) {
                this.size = Integer.parseInt((String)value);
            }
            if ((value = this.attr.getAttribute(MCSS.Attribute.WIDTH)) != null && value instanceof MCSS.LengthValue) {
                this.widthValue = (MCSS.LengthValue)value;
            }
            this.topMargin = this.getLength(MCSS.Attribute.MARGIN_TOP, this.attr);
            this.bottomMargin = this.getLength(MCSS.Attribute.MARGIN_BOTTOM, this.attr);
            this.leftMargin = this.getLength(MCSS.Attribute.MARGIN_LEFT, this.attr);
            this.rightMargin = this.getLength(MCSS.Attribute.MARGIN_RIGHT, this.attr);
        } else {
            this.rightMargin = 0.0f;
            this.leftMargin = 0.0f;
            this.bottomMargin = 0.0f;
            this.topMargin = 0.0f;
        }
        this.size = Math.max(2, this.size);
    }

    private float getLength(MCSS.Attribute key, AttributeSet a) {
        MCSS.LengthValue lv = (MCSS.LengthValue)a.getAttribute(key);
        float len = lv != null ? lv.getValue() : 0.0f;
        return len;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        Rectangle alloc = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        int x = 0;
        int y = alloc.y + 3 + (int)this.topMargin;
        int width = alloc.width - (int)(this.leftMargin + this.rightMargin);
        if (this.widthValue != null) {
            width = (int)this.widthValue.getValue(width);
        }
        int height = alloc.height - (6 + (int)this.topMargin + (int)this.bottomMargin);
        if (this.size > 0) {
            height = this.size;
        }
        switch (this.alignment) {
            case 1: {
                x = alloc.x + alloc.width / 2 - width / 2;
                break;
            }
            case 2: {
                x = alloc.x + alloc.width - width - (int)this.rightMargin;
                break;
            }
            default: {
                x = alloc.x + (int)this.leftMargin;
            }
        }
        if (this.noshade != null) {
            g.setColor(Color.black);
            g.fillRect(x, y, width, height);
        } else {
            Color bottom;
            Color top;
            Color bg = this.getContainer().getBackground();
            if (bg == null || bg.equals(Color.white)) {
                top = Color.darkGray;
                bottom = Color.lightGray;
            } else {
                top = Color.darkGray;
                bottom = Color.white;
            }
            g.setColor(bottom);
            g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            g.drawLine(x, y + height - 1, x + width - 1, y + height - 1);
            g.setColor(top);
            g.drawLine(x, y, x + width - 1, y);
            g.drawLine(x, y, x, y + height - 1);
        }
    }

    @Override
    public float getPreferredSpan(int axis) {
        switch (axis) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                if (this.size > 0) {
                    return (float)(this.size + 3 + 3) + this.topMargin + this.bottomMargin;
                }
                if (this.noshade != null) {
                    return 8.0f + this.topMargin + this.bottomMargin;
                }
                return 6.0f + this.topMargin + this.bottomMargin;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public int getResizeWeight(int axis) {
        if (axis == 0) {
            return 1;
        }
        if (axis == 1) {
            return 0;
        }
        return 0;
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        if (axis == 0) {
            return 3000;
        }
        return 0;
    }

    @Override
    public View breakView(int axis, int offset, float pos, float len) {
        return null;
    }

    @Override
    public Shape modelToView(int pos, Shape a, Position.Bias b) throws BadLocationException {
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (pos >= p0 && pos <= p1) {
            Rectangle r = a.getBounds();
            if (pos == p1) {
                r.x += r.width;
            }
            r.width = 0;
            return r;
        }
        return null;
    }

    @Override
    public int viewToModel(float x, float y, Shape a, Position.Bias[] bias) {
        Rectangle alloc = (Rectangle)a;
        if (x < (float)(alloc.x + alloc.width / 2)) {
            bias[0] = Position.Bias.Forward;
            return this.getStartOffset();
        }
        bias[0] = Position.Bias.Backward;
        return this.getEndOffset();
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attr;
    }

    @Override
    public void changedUpdate(DocumentEvent changes, Shape a, ViewFactory f) {
        super.changedUpdate(changes, a, f);
        int pos = changes.getOffset();
        if (pos <= this.getStartOffset() && pos + changes.getLength() >= this.getEndOffset()) {
            this.setPropertiesFromAttributes();
        }
    }
}

