/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MCSS;
import com.mongol.swing.text.html.MHTMLDocument;
import com.mongol.swing.text.html.MStyleSheet;
import java.awt.Color;
import java.awt.Container;
import java.awt.FontMetrics;
import java.awt.Shape;
import java.text.BreakIterator;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.LabelView;
import javax.swing.text.Segment;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class MInlineView
extends LabelView {
    private boolean nowrap;
    private AttributeSet attr;
    private float longestWordSpan = -1.0f;

    public MInlineView(Element elem) {
        super(elem);
        MStyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
    }

    @Override
    public void insertUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.insertUpdate(e, a, f);
        this.longestWordSpan = -1.0f;
    }

    @Override
    public void removeUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.removeUpdate(e, a, f);
        this.longestWordSpan = -1.0f;
    }

    @Override
    public void changedUpdate(DocumentEvent e, Shape a, ViewFactory f) {
        super.changedUpdate(e, a, f);
        MStyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        this.longestWordSpan = -1.0f;
        this.preferenceChanged(null, true, true);
    }

    @Override
    public AttributeSet getAttributes() {
        return this.attr;
    }

    @Override
    public int getBreakWeight(int axis, float pos, float len) {
        if (this.nowrap) {
            return 0;
        }
        return super.getBreakWeight(axis, pos, len);
    }

    @Override
    public View breakView(int axis, int offset, float pos, float len) {
        MInlineView view = (MInlineView)super.breakView(axis, offset, pos, len);
        if (view != this) {
            view.longestWordSpan = -1.0f;
        }
        return view;
    }

    float getLongestWordSpan() {
        if (this.longestWordSpan < 0.0f) {
            this.longestWordSpan = this.calculateLongestWordSpan();
        }
        return this.longestWordSpan;
    }

    float calculateLongestWordSpan() {
        float rv = 0.0f;
        Document doc = this.getDocument();
        String MultiByteProperty = "multiByte";
        rv = doc != null && Boolean.TRUE.equals(doc.getProperty(MultiByteProperty)) ? this.calculateLongestWordSpanUseBreakIterator() : this.calculateLongestWordSpanUseWhitespace();
        return rv;
    }

    float calculateLongestWordSpanUseBreakIterator() {
        float span = 0.0f;
        Document doc = this.getDocument();
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (p1 > p0) {
            try {
                FontMetrics metrics = this.getFontMetrics();
                Segment segment = new Segment();
                doc.getText(p0, p1 - p0, segment);
                Container c = this.getContainer();
                BreakIterator line = c != null ? BreakIterator.getLineInstance(c.getLocale()) : BreakIterator.getLineInstance();
                line.setText(segment);
                int start = line.first();
                int end = line.next();
                while (end != -1) {
                    if (end > start) {
                        span = Math.max(span, (float)metrics.charsWidth(segment.array, start, end - start));
                    }
                    start = end;
                    end = line.next();
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return span;
    }

    float calculateLongestWordSpanUseWhitespace() {
        float span = 0.0f;
        Document doc = this.getDocument();
        int p0 = this.getStartOffset();
        int p1 = this.getEndOffset();
        if (p1 > p0) {
            try {
                int start;
                Segment segment = new Segment();
                doc.getText(p0, p1 - p0, segment);
                boolean CONTENT = false;
                boolean SPACES = true;
                boolean state = false;
                int end = start = segment.offset;
                FontMetrics metrics = this.getFontMetrics();
                int lastIndex = segment.offset + segment.count - 1;
                int i = segment.offset;
                while (i <= lastIndex) {
                    boolean updateSpan = false;
                    if (Character.isWhitespace(segment.array[i])) {
                        if (!state) {
                            updateSpan = true;
                            state = true;
                        }
                    } else {
                        if (state) {
                            end = start = i;
                            state = false;
                        } else {
                            end = i;
                        }
                        if (i == lastIndex) {
                            updateSpan = true;
                        }
                    }
                    if (updateSpan && end > start) {
                        span = Math.max(span, (float)metrics.charsWidth(segment.array, start, end - start + 1));
                    }
                    ++i;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return span;
    }

    @Override
    protected void setPropertiesFromAttributes() {
        super.setPropertiesFromAttributes();
        AttributeSet a = this.getAttributes();
        Object decor = a.getAttribute(MCSS.Attribute.TEXT_DECORATION);
        boolean u = decor != null ? decor.toString().indexOf("underline") >= 0 : false;
        this.setUnderline(u);
        boolean s = decor != null ? decor.toString().indexOf("line-through") >= 0 : false;
        this.setStrikeThrough(s);
        Object vAlign = a.getAttribute(MCSS.Attribute.VERTICAL_ALIGN);
        s = vAlign != null ? vAlign.toString().indexOf("sup") >= 0 : false;
        this.setSuperscript(s);
        s = vAlign != null ? vAlign.toString().indexOf("sub") >= 0 : false;
        this.setSubscript(s);
        Object whitespace = a.getAttribute(MCSS.Attribute.WHITE_SPACE);
        this.nowrap = whitespace != null && whitespace.equals("nowrap");
        MHTMLDocument doc = (MHTMLDocument)this.getDocument();
        Color bg = doc.getBackground(a);
        if (bg != null) {
            this.setBackground(bg);
        }
    }

    protected MStyleSheet getStyleSheet() {
        MHTMLDocument doc = (MHTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }
}

