/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.MParagraphView;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.View;

public class MLineView
extends MParagraphView {
    int tabBase;

    public MLineView(Element elem) {
        super(elem);
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public float getMinimumSpan(int axis) {
        return this.getPreferredSpan(axis);
    }

    @Override
    public int getResizeWeight(int axis) {
        switch (axis) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + axis);
    }

    @Override
    public float getAlignment(int axis) {
        if (axis == 0) {
            return 0.0f;
        }
        return super.getAlignment(axis);
    }

    @Override
    protected void layout(int width, int height) {
        super.layout(0x7FFFFFFE, height);
    }

    @Override
    public float nextTabStop(float x, int tabOffset) {
        if (this.getTabSet() == null && StyleConstants.getAlignment(this.getAttributes()) == 0) {
            return this.getPreTab(x, tabOffset);
        }
        return super.nextTabStop(x, tabOffset);
    }

    protected float getPreTab(float x, int tabOffset) {
        Document d = this.getDocument();
        View v = this.getViewAtPosition(tabOffset, null);
        if (d instanceof StyledDocument && v != null) {
            Font f = ((StyledDocument)d).getFont(v.getAttributes());
            Container c = this.getContainer();
            FontMetrics fm = c != null ? c.getFontMetrics(f) : Toolkit.getDefaultToolkit().getFontMetrics(f);
            int width = this.getCharactersPerTab() * fm.charWidth('W');
            int tb = (int)this.getTabBase();
            return (((int)x - tb) / width + 1) * width + tb;
        }
        return 10.0f + x;
    }

    protected int getCharactersPerTab() {
        return 8;
    }
}

