/*
 * Decompiled with CFR 0.152.
 */
package com.mongol.swing.text.html;

import com.mongol.swing.text.html.MBlockView;
import com.mongol.swing.text.html.MCSS;
import com.mongol.swing.text.html.MHTMLDocument;
import com.mongol.swing.text.html.MInlineView;
import com.mongol.swing.text.html.MStyleSheet;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;

public class MParagraphView
extends com.mongol.swing.text.MParagraphView {
    private AttributeSet attr;
    private MStyleSheet.BoxPainter painter;
    private MCSS.LengthValue cssWidth;
    private MCSS.LengthValue cssHeight;

    public MParagraphView(Element elem) {
        super(elem);
    }

    @Override
    public void setParent(View parent) {
        super.setParent(parent);
        if (parent != null) {
            this.setPropertiesFromAttributes();
        }
    }

    @Override
    public AttributeSet getAttributes() {
        if (this.attr == null) {
            MStyleSheet sheet = this.getStyleSheet();
            this.attr = sheet.getViewAttributes(this);
        }
        return this.attr;
    }

    @Override
    protected void setPropertiesFromAttributes() {
        MStyleSheet sheet = this.getStyleSheet();
        this.attr = sheet.getViewAttributes(this);
        this.painter = sheet.getBoxPainter(this.attr);
        if (this.attr != null) {
            super.setPropertiesFromAttributes();
            this.setInsets((short)this.painter.getInset(1, this), (short)this.painter.getInset(2, this), (short)this.painter.getInset(3, this), (short)this.painter.getInset(4, this));
            Object o = this.attr.getAttribute(MCSS.Attribute.TEXT_ALIGN);
            if (o != null) {
                String ta = o.toString();
                if (ta.equals("left")) {
                    this.setJustification(0);
                } else if (ta.equals("center")) {
                    this.setJustification(1);
                } else if (ta.equals("right")) {
                    this.setJustification(2);
                } else if (ta.equals("justify")) {
                    this.setJustification(3);
                }
            }
            this.cssWidth = (MCSS.LengthValue)this.attr.getAttribute(MCSS.Attribute.WIDTH);
            this.cssHeight = (MCSS.LengthValue)this.attr.getAttribute(MCSS.Attribute.HEIGHT);
        }
    }

    protected MStyleSheet getStyleSheet() {
        MHTMLDocument doc = (MHTMLDocument)this.getDocument();
        return doc.getStyleSheet();
    }

    @Override
    protected SizeRequirements calculateMinorAxisRequirements(int axis, SizeRequirements r) {
        if (!MBlockView.spanSetFromAttributes(axis, r = super.calculateMinorAxisRequirements(axis, r), this.cssWidth, this.cssHeight)) {
            float min = 0.0f;
            int n = this.getLayoutViewCount();
            int i = 0;
            while (i < n) {
                View v = this.getLayoutView(i);
                if (v instanceof MInlineView) {
                    float wordSpan = ((MInlineView)v).getLongestWordSpan();
                    min = Math.max(wordSpan, min);
                } else {
                    min = Math.max(v.getMinimumSpan(axis), min);
                }
                ++i;
            }
            r.minimum = Math.max(r.minimum, (int)min);
            r.preferred = Math.max(r.minimum, r.preferred);
            r.maximum = Math.max(r.preferred, r.maximum);
        } else {
            int margin = axis == 0 ? this.getLeftInset() + this.getRightInset() : this.getTopInset() + this.getBottomInset();
            r.minimum -= margin;
            r.preferred -= margin;
            r.maximum -= margin;
        }
        return r;
    }

    @Override
    public boolean isVisible() {
        View v;
        int n = this.getLayoutViewCount() - 1;
        int i = 0;
        while (i < n) {
            View v2 = this.getLayoutView(i);
            if (v2.isVisible()) {
                return true;
            }
            ++i;
        }
        if (n > 0 && (v = this.getLayoutView(n)).getEndOffset() - v.getStartOffset() == 1) {
            return false;
        }
        if (this.getStartOffset() == this.getDocument().getLength()) {
            boolean editable = false;
            Container c = this.getContainer();
            if (c instanceof JTextComponent) {
                editable = ((JTextComponent)c).isEditable();
            }
            if (!editable) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void paint(Graphics g, Shape a) {
        if (a == null) {
            return;
        }
        Rectangle r = a instanceof Rectangle ? (Rectangle)a : a.getBounds();
        this.painter.paint(g, r.x, r.y, r.width, r.height, this);
        super.paint(g, a);
    }

    @Override
    public float getPreferredSpan(int axis) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getPreferredSpan(axis);
    }

    @Override
    public float getMinimumSpan(int axis) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMinimumSpan(axis);
    }

    @Override
    public float getMaximumSpan(int axis) {
        if (!this.isVisible()) {
            return 0.0f;
        }
        return super.getMaximumSpan(axis);
    }
}

